% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rIACI.R
\name{iaci_output}
\alias{iaci_output}
\title{Calculate Integrated Iberian Actuarial Climate Index (IACI)}
\usage{
iaci_output(ci, si, freq = c("monthly", "seasonal"))
}
\arguments{
\item{ci}{List. Climate input object.}

\item{si}{Data frame. Sea level input data.}

\item{freq}{Character. Frequency of calculation, either "monthly" or "seasonal".}
}
\value{
Data frame with dates and IACI values.
}
\description{
Integrates various standardized indices to compute the IACI.
}
\examples{
\donttest{
# 1. Generate a climate_input object
dates <- seq.Date(
  from = as.Date("1960-01-01"),
  to   = as.Date("2020-12-31"),
  by   = "day"
)
n <- length(dates)
tmax <- runif(n, min = 5, max = 40)
tmin <- runif(n, min = -10,  max = 5)
# Example: use a Poisson distribution to simulate precipitation
prec <- rpois(n, lambda = 2)
# Random wind speeds, e.g., 0 to 10 m/s
wind <- runif(n, min = 0, max = 10)
ci <- climate_input(
  tmax  = tmax,
  tmin  = tmin,
  prec  = prec,
  wind  = wind,
  dates = dates
)
# 2. Create a sea level data frame with sea_input()
monthly_seq <- seq.Date(
  from = as.Date("1960-01-01"),
  to   = as.Date("2020-12-01"),
  by   = "month"
)
sea_dates <- format(monthly_seq, "\%Y-\%m")
n <- length(sea_dates)
linear_trend <- seq(0, 10, length.out = n)
random_noise <- rnorm(n, mean = 0, sd = 0.3)
sea_values   <- 10 + linear_trend + random_noise  # starts ~10, ends ~20
si <- sea_input(Date = sea_dates, Value = sea_values)
# Then:
# 3. Calculate the IACI with monthly frequency
result <- iaci_output(ci, si, freq = "monthly")
}
}
