% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animBathy.R
\name{animBathy}
\alias{animBathy}
\title{Generate Animated Plot}
\usage{
animBathy(
  DEM,
  units = "ft",
  littoral = TRUE,
  secchi = NULL,
  photic = NULL,
  stop = NULL,
  by = 1
)
}
\arguments{
\item{DEM}{SpatRaster object of a given waterbody, rasters can be transformed to SpatRaster via the rast() function in 'terra'}

\item{units}{character describing depth units of DEM. Can be meters ("m") or feet ("ft"). Default = "ft"}

\item{littoral}{logical indicating if littoral zone should be plotted (T) or entire waterbody (F), default = TRUE}

\item{secchi}{number giving the average Secchi depth of the waterbody, photic zone estimated as 2.6m * secchi}

\item{photic}{number giving the average photic depth of the waterbody, overwrites Secchi}

\item{stop}{optional numeric value specifying depth at which to stop animation, default = NULL (all depths)}

\item{by}{numeric value specifying depth increments between plots. Higher values will result in lower resolution. Default = 1}
}
\value{
an animated ggplot object
}
\description{
Generate an animated plot of littoral area at different water level increments from a raster digital elevation model (DEM).
}
\examples{
\donttest{
#load raster
DEM <- terra::rast(system.file("extdata", "example_raster.tif", package = 'rLakeHabitat'))
\dontshow{.old_wd <- setwd(tempdir())}
#run function
animBathy(DEM, units = 'm', littoral = TRUE, secchi = 1, by = 5)
\dontshow{setwd(.old_wd)}}
}
\author{
Tristan Blechinger, Department of Zoology & Physiology, University of Wyoming
}
