% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVP.MLM.r
\name{MVP.MLM}
\alias{MVP.MLM}
\title{To perform GWAS with GLM and MLM model and get the P value of SNPs}
\usage{
MVP.MLM(
  phe,
  geno,
  K = NULL,
  eigenK = NULL,
  CV = NULL,
  ind_idx = NULL,
  mrk_idx = NULL,
  mrk_bycol = TRUE,
  REML = NULL,
  maxLine = 5000,
  cpu = 1,
  vc.method = c("BRENT", "EMMA", "HE"),
  verbose = TRUE
)
}
\arguments{
\item{phe}{phenotype, n * 2 matrix}

\item{geno}{genotype, either m by n or n by m is supportable, m is marker size, n is population size}

\item{K}{Kinship, Covariance matrix(n * n) for random effects; must be positive semi-definite}

\item{eigenK}{list of eigen Kinship}

\item{CV}{covariates}

\item{ind_idx}{the index of effective genotyped individuals}

\item{mrk_idx}{the index of effective markers used in analysis}

\item{mrk_bycol}{whether the markers are stored by columns in genotype (i.e. M is a n by m matrix)}

\item{REML}{a list that contains ve and vg}

\item{maxLine}{the number of markers handled at a time, smaller value would reduce the memory cost}

\item{cpu}{number of cpus used for parallel computation}

\item{vc.method}{the methods for estimating variance component("emma" or "he" or "brent")}

\item{verbose}{whether to print detail.}
}
\value{
results: a m * 2 matrix, the first column is the SNP effect, the second column is the P values
}
\description{
To perform GWAS with GLM and MLM model and get the P value of SNPs
}
\examples{
\donttest{
phePath <- system.file("extdata", "07_other", "mvp.phe", package = "rMVP")
phenotype <- read.table(phePath, header=TRUE)
idx <- !is.na(phenotype[, 2])
phenotype <- phenotype[idx, ]
print(dim(phenotype))
genoPath <- system.file("extdata", "06_mvp-impute", "mvp.imp.geno.desc", package = "rMVP")
genotype <- attach.big.matrix(genoPath)
genotype <- deepcopy(genotype, rows=idx)
print(dim(genotype))
K <- MVP.K.VanRaden(genotype, cpu=1)

mlm <- MVP.MLM(phe=phenotype, geno=genotype, K=K, cpu=1)
str(mlm)
}

}
\author{
Lilin Yin and Xiaolei Liu
}
