% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inla_rspde_1d.R
\name{predict.inla_rspde_matern1d}
\alias{predict.inla_rspde_matern1d}
\title{Predict method for 'inlabru' stationary Matern 1d models}
\usage{
\method{predict}{inla_rspde_matern1d}(
  object,
  cmp,
  bru_fit,
  newdata = NULL,
  formula = NULL,
  n.samples = 100,
  seed = 0L,
  probs = c(0.025, 0.5, 0.975),
  return_original_order = TRUE,
  num.threads = NULL,
  include = NULL,
  exclude = NULL,
  drop = FALSE,
  tolerance = 1e-04,
  ...
)
}
\arguments{
\item{object}{An \code{inla_rspde_matern1d} object built with the \code{rspde.matern1d()}
function.}

\item{cmp}{The 'inlabru' component used to fit the model.}

\item{bru_fit}{A fitted model using 'inlabru' or 'INLA'.}

\item{newdata}{A data.frame of covariates needed for the prediction.}

\item{formula}{A formula where the right hand side defines an R expression to
evaluate for each generated sample. If NULL, the latent and hyperparameter
states are returned as named list elements. See Details for more information.}

\item{n.samples}{Integer setting the number of samples to draw in order to
calculate the posterior statistics. The default is rather low but provides a
quick approximate result.}

\item{seed}{Random number generator seed passed on to \code{inla.posterior.sample()}}

\item{probs}{A numeric vector of probabilities with values in the standard
unit interval to be passed to stats::quantile}

\item{return_original_order}{Should the predictions be returned in the
original order?}

\item{num.threads}{Specification of desired number of threads for parallel
computations. Default NULL, leaves it up to 'INLA'. When seed != 0, overridden to "1:1"}

\item{include}{Character vector of component labels that are needed by the
predictor expression; Default: NULL (include all components that are not
explicitly excluded)}

\item{exclude}{Character vector of component labels that are not used by the
predictor expression. The exclusion list is applied to the list as determined
by the include parameter; Default: NULL (do not remove any components from
the inclusion list)}

\item{drop}{logical; If keep=FALSE, data is a SpatialDataFrame, and the
prediciton summary has the same number of rows as data, then the output is a
SpatialDataFrame object. Default FALSE.}

\item{tolerance}{Tolerance for merging locations.}

\item{...}{Additional arguments passed on to \code{inla.posterior.sample()}.}
}
\value{
A list with predictions.
}
\description{
Auxiliar function to obtain predictions of the stationary Matern 1d models
using 'inlabru'.
}
