% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stationary1d.R
\name{simulate.rSPDEobj1d}
\alias{simulate.rSPDEobj1d}
\title{Simulation of a Matern field using a rational SPDE approximation}
\usage{
\method{simulate}{rSPDEobj1d}(object, nsim = 1, seed = NULL, ...)
}
\arguments{
\item{object}{The rational SPDE approximation, computed
using \code{\link[=matern.rational]{matern.rational()}}.}

\item{nsim}{The number of simulations.}

\item{seed}{an object specifying if and how the random number generator should be initialized (‘seeded’).}

\item{...}{Currently not used.}
}
\value{
A matrix with the \code{n} samples as columns.
}
\description{
The function samples a Gaussian random field based on a
pre-computed rational SPDE approximation.
}
\examples{
# Sample a Gaussian Matern process on R using a rational approximation
range <- 0.2
sigma <- 1
nu <- 0.8

# compute rational approximation
x <- seq(from = 0, to = 1, length.out = 100)
op <- matern.rational(
  range = range, sigma = sigma,
  nu = nu, loc = x
)

# Sample the model and plot the result
Y <- simulate(op)
plot(x, Y, type = "l", ylab = "u(x)", xlab = "x")

}
\seealso{
\code{\link[=matern.rational]{matern.rational()}}
}
