% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcnp_mesh_bins.R
\name{mcnp_mesh_bins}
\alias{mcnp_mesh_bins}
\title{Make mesh tally size settings for MCNP}
\usage{
mcnp_mesh_bins(
  target,
  width,
  lowest_less,
  lowest_high,
  highest_high,
  highest_less
)
}
\arguments{
\item{target}{the desired center a single mesh}

\item{width}{the individual mesh}

\item{lowest_less}{in the direction of a decreasing dimension,
what is the lowest that it can go and still be acceptable?}

\item{lowest_high}{in the direction of an increasing dimension,
what is the lowest that it can go and still be acceptable?}

\item{highest_high}{in the direction of an increasing dimension,
what is the highest that it can go and still be acceptable?}

\item{highest_less}{in the direction of a decreasing dimension,
what is the highest that it can go and still be acceptable?}
}
\value{
a data frame providing:

low_set, the minimum dimension. This is probably best used in
the origin parameter in the MCNP mesh tally.
high_set, the maximum dimension for the bin. This can be
identified in the MCNP mesh tally setting of imesh, jmesh, or
kmesh.
width, this is just a return of the parameter supplied to the
function.
numblocks, the number of fine meshes. This can be used in the
MCNP mesh tally setting of iints, jints, or kints.
}
\description{
#' \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}:
Find the parameters needed for a rectilinear "superimposed mesh
tally b" in MCNP. It can be a challenge to center mesh tally
bins at a desired value of x, y, or z. This function looks at a
single dimension, -- in units of cm -- at a time. This is a new
function and hasn't been tested thoroughly. The idea is to
identify a single setting in the MCNP mesh tally for
imesh and iints (or jmesh and jints or kmesh and kints). It
is designed only for uniform mesh bin sizes.
}
\examples{
mcnp_mesh_bins(target = 30, width = 10, lowest_less = 0,
 highest_less = 15, highest_high = 304.8, lowest_high = 250)
#'
}
\seealso{
Other mcnp tools: 
\code{\link{mcnp_cone_angle}()},
\code{\link{mcnp_est_nps}()},
\code{\link{mcnp_matrix_rotations}()},
\code{\link{mcnp_plot_out_spec}()},
\code{\link{mcnp_scan2plot}()},
\code{\link{mcnp_scan_save}()},
\code{\link{mcnp_sdef_erg_hist}()},
\code{\link{mcnp_sdef_erg_line}()}
}
\concept{mcnp tools}
