% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/well.R
\name{headwell}
\alias{headwell}
\title{Create a analytic element of a well with a constant head}
\usage{
headwell(xw, yw, hc, rw = 0.3, xc = xw, yc = yw, rc = rw, resistance = 0, ...)
}
\arguments{
\item{xw}{numeric, x location of the well.}

\item{yw}{numeric, y location of the well.}

\item{hc}{numeric, specified hydraulic head at the collocation point.}

\item{rw}{numeric, radius of the well. Defaults to 0.3 (meter).}

\item{xc}{numeric, x location of the collocation point. See details. Defaults to \code{xw}.}

\item{yc}{numeric, y location of the collocation point. See details. Defaults to \code{yw}.}

\item{rc}{numeric, radius of the collocation point. See details. Defaults to \code{rw}.}

\item{resistance}{numeric, hydraulic resistance at the collocation point. Defaults to 0 (no resistance).}

\item{...}{ignored}
}
\value{
Analytic element of a well with constant head which is an object of class \code{headwell} and inherits from \code{well}.
}
\description{
\code{\link[=headwell]{headwell()}} creates an analytic element of a well with a constant, specified head. The discharge
into the well is computed by solving the corresponding \code{aem} model. The head can be specified at
the well or at any other location.
}
\details{
The discharge from the well at location \code{xw - yw} is computed by solving the \code{aem} model given
the specified head \code{hc}. This head is specified at \code{xc + rc - yc}, called the collocation point.
This can be used to compute the discharge of the well by specifying the head at some other location.
By default, the location of the well and the collocation point are the same.

The hydraulic resistance of the well screen at the collocation point can be increased for a well in poor connection with
the aquifer. If the aquifer is unconfined (i.e. has a variable saturated thickness), the system of equations becomes
non-linear with respect to the hydraulic head and iteration is required to solve the model.
}
\examples{
hw <- headwell(xw = 400, yw = 300, hc = 20, rw = 0.3)
hw <- headwell(xw = 400, yw = 300, hc = 20, rw = 0.3, resistance = 10)
hw <- headwell(xw = 400, yw = 300, hc = 20, rw = 0.3, xc = 500, yc = 500, rc = 0)

}
\seealso{
\code{\link[=well]{well()}}
}
