% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitslope.R
\name{fitslope}
\alias{fitslope}
\title{Compute logarithmic slope of a spatial power spectrum}
\usage{
fitslope(fx, kmin = 1, kmax = length(fx))
}
\arguments{
\item{fx}{vector containing input power spectrum starting from \code{k=1}.}

\item{kmin}{minimum wavenumber for logarithmic fit range.}

\item{kmax}{maximum wavenumber for logarithmic fit range.}
}
\value{
The spatial spectral slope minus one. The slope is returned as the
logarithmic slope of k*|A(k)|^2 where |A(k)|^2 are the squared spectral
amplitudes provided in input..
}
\description{
Uses a linear fit to derive the log-log slope of a
Fourier power spectrum.
}
\examples{
# Make a synthetic rainfall field with prescribed logarithmic spectral slope
f = initmetagauss(1.7, 64)
r = metagauss(f)
# Check spectral slope of the resulting field
fx <- fft2d(r)
print(fitslope(fx))
# 1.640373
}
\author{
Jost von Hardenberg, \email{j.vonhardenberg@isac.cnr.it}
}
