% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authenticate.R
\name{td_auth_accessToken}
\alias{td_auth_accessToken}
\title{Auth Step 3: Get Access Token}
\usage{
td_auth_accessToken(consumerKey, refreshToken)
}
\arguments{
\item{consumerKey}{TD generated Consumer key for the registered TD app.
Essentially an API key.}

\item{refreshToken}{An existing Refresh Token generated using
\code{\link{td_auth_refreshToken}}}
}
\value{
Access Token that is valid for 30 minutes. By default it is stored in
  options.
}
\description{
Get a new Access Token using a valid Refresh Token
}
\details{
An Access Token is required for the functions within rameritrade. It serves
as a user login to a TD Brokerage account. The token is valid for 30 minutes
and allows the user to place trades, get account information, get order
history, pull historical stock prices, etc. A Refresh Token is required to
generate an Access Token. \code{\link{td_auth_refreshToken}}  can be used to
generate Refresh Tokens which stay valid for 90 days. The Consumer Key is
generated automatically when an App is registered on the
\href{https://developer.tdameritrade.com/}{TD Ameritrade Developer} site. By
default, the Access Token is stored into options and will automatically be
passed to downstream functions. However, the user can also submit an Access
Token manually if multiple tokens are in use (for example: when managing more
than one log in.)

When running this function manually (i.e. through RStudio), the function will
check for a default Access Token. If the default Access Token has not
expired, the user will be prompted to verify a new Access Token is desired.
This may be the case if more than one TD login is being used. When running
this function in a non-interactive environment (i.e. CRON Job), the default
behavior will be to refresh the Access Token.

DISCLOSURE: This software is in no way affiliated, endorsed, or approved by
TD Ameritrade or any of its affiliates. It comes with absolutely no warranty
and should not be used in actual trading unless the user can read and
understand the source code. The functions within this package have been
tested under basic scenarios. There may be bugs or issues that could prevent
a user from executing trades or canceling trades. It is also possible trades
could be submitted in error. The user will use this package at their own
risk.
}
\examples{
\dontrun{

# A valid Refresh Token can be fed into the function below for a new Access Token
refreshToken = readRDS('/secure/location/')
accessToken = td_auth_accessToken('TD_CONSUMER_KEY', refreshToken)

}
}
\seealso{
\code{\link{td_auth_loginURL}} to generate a login url which leads
  to an authorization code, \code{\link{td_auth_refreshToken}} to generate a
  Refresh Token using an existing Refresh Token or an authorization code with
  a callback URL when logging in manually,  \code{\link{td_auth_accessToken}}
  to generate a new Access Token
}
