% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_prop_size.R
\name{pair_prop_size}
\alias{pair_prop_size}
\title{Sample Size or Power for Paired-Sample Proportion Test}
\usage{
pair_prop_size(p01, p10, alpha, beta = NULL, n = NULL, test_type = "2-side")
}
\arguments{
\item{p01}{Numeric. Proportion of discordant pairs with (before = 1, after = 0).}

\item{p10}{Numeric. Proportion of discordant pairs with (before = 0, after = 1).}

\item{alpha}{Numeric. Type I error rate.}

\item{beta}{Numeric (optional). Type II error rate. Required for sample size calculation.}

\item{n}{Integer (optional). Sample size. Required for power calculation.}

\item{test_type}{Character. \code{"2-side"} or \code{"1-side"}. Default is \code{"2-side"}.}
}
\value{
Numeric. Returns sample size (if \code{beta} is given), or power (if \code{n} is given).
}
\description{
Calculates sample size or power for a paired-sample proportion test.
}
\note{
Only one of \code{beta} (for sample size calculation) or \code{n} (for power calculation) should be specified.

Required arguments:
\itemize{
\item For sample size: \code{p01}, \code{p10}, \code{alpha}, \code{beta}
\item For power: \code{p01}, \code{p10}, \code{alpha}, \code{n}
}
}
\examples{
# Sample size for `"2-side"` test
pair_prop_size(p01 = 0.45, p10 = 0.05,
               alpha = 0.1, beta = 0.1, test_type = "2-side")

# Power of `"2-side"` test
pair_prop_size(p01 = 0.45, p10 = 0.05,
               alpha = 0.1, n = 23, test_type = "2-side")

# Sample size for `"1-side"` test
pair_prop_size(p01 = 0.45, p10 = 0.05,
               alpha = 0.05, beta = 0.1, test_type = "1-side")

# Power of `"1-side"` test
pair_prop_size(p01 = 0.45, p10 = 0.05,
               alpha = 0.05, n = 23, test_type = "1-side")

}
