% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_comparison.R
\name{waic.rater_fit}
\alias{waic.rater_fit}
\alias{waic}
\title{Compute the WAIC - a measure of model fit - of a rater fit object.}
\usage{
\method{waic}{rater_fit}(x, ...)
}
\arguments{
\item{x}{A \code{rater_fit} object. All model types are currently supported
except the basic Dawid-Skene model fit with grouped data.}

\item{...}{Other arguments passed.}
}
\value{
A waic/loo object.
}
\description{
Compute the WAIC - a measure of model fit - of a rater fit object.
}
\details{
This function provides provides an additional method for model
comparison, on top of the \code{loo()} function. In general we recommend that
\code{loo()} is preferred: see the documentation of the loo package for details.
Also, note the comments regarding model selection the the details section
of \code{loo()}.
}
\examples{

\donttest{
fit_ds <- rater(anesthesia, "dawid_skene", verbose = FALSE, chains = 1)
fit_ccds <- rater(anesthesia, "class_conditional_dawid_skene",
                  verbose = FALSE, chains = 1)

waic(fit_ds)
waic(fit_ccds)
}

}
\references{
Watanabe, S. (2010). Asymptotic equivalence of Bayes cross validation and
widely application information criterion in singular learning theory.
\emph{Journal of Machine Learning Research} 11, 3571-3594.

Vehtari, A., Gelman, A., and Gabry, J. (2017a). Practical Bayesian model
evaluation using leave-one-out cross-validation and WAIC.
\emph{Statistics and Computing}. 27(5), 1413--1432. doi:10.1007/s11222-016-9696-4
(\href{https://link.springer.com/article/10.1007/s11222-016-9696-4}{journal version},
\href{https://arxiv.org/abs/1507.04544}{preprint arXiv:1507.04544}).
}
