% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow-wavelet.R
\name{run_wavelet}
\alias{run_wavelet}
\title{Apply Morlet-Wavelet to subject}
\usage{
run_wavelet(
  subject,
  electrodes,
  freqs,
  cycles,
  target_sample_rate = 100,
  kernels_precision = "float",
  pre_downsample = 1,
  verbose = TRUE
)
}
\arguments{
\item{subject}{'RAVE' subject or subject ID}

\item{electrodes}{electrode channels to apply, must be imported and
\code{'LFP'} type}

\item{freqs}{numeric vector of frequencies to apply}

\item{cycles}{number of wavelet cycles at each \code{freqs}, integers}

\item{target_sample_rate}{the resulting 'spectrogram' sampling frequency}

\item{kernels_precision}{double or single (default) floating precision}

\item{pre_downsample}{down-sample (integer) priory to the decomposition;
set to 1 (default) to avoid}

\item{verbose}{whether to verbose the progress}
}
\value{
The decomposition results are stored in 'RAVE' subject data path;
the function only returns the wavelet parameters.
}
\description{
Calculates time-frequency decomposition; not intended for direct use.
Please use 'RAVE' pipelines (see 'Examples').
}
\details{
The channel signals are first down-sampled (optional) by a ratio of
\code{pre_downsample} via a 'FIR' filter. After the down-sample,
'Morlet' wavelet kernels are applied to the signals to calculate the
wavelet coefficients (complex number) at each frequency in \code{freqs}.
The number of \code{cycles} at each frequency controls the number of
sine and cosine waves, allowing users to balance the time and power
accuracy. After the decomposition, the 'spectrogram' is further down-sampled
to \code{target_sample_rate}, assuming the brain power is a smooth function
over time. This down-sample is done via time-point sampling to preserve the
phase information (so the linear functions such as common-average or
bi-polar reference can be carried over to the complex coefficients).
}
\examples{

# Check https://rave.wiki for additional pipeline installation

\dontrun{

# ---- Recommended usage --------------------------------------------


pipeline <- ravepipeline::pipeline("wavelet_module")
pipeline$set_settings(
  project_name = "demo",
  subject_code = "DemoSubject",
  precision = "float",
  pre_downsample = 4,
  kernel_table = ravetools::wavelet_cycles_suggest(
    freqs = seq(1, 200, by = 1)),
  target_sample_rate = 100
)

# Internally, the above pipeline includes this function call below

# ---- For demonstration use, do not call this function directly ----

# Original sample rate: 2000 Hz
# Downsample by 4 to 500 Hz first - 250 Hz Nyquist
# Wavelet at each 1, 2, ..., 200 Hz
#   The number of cycles log-linear from 2 to 20
#   The wavelet coefficient sample rate is 500 Hz
# Further down-sample to 100 Hz to save storage space

run_wavelet(
  subject = "demo/DemoSubject",
  electrodes = c(13:16, 2),
  pre_downsample = 4,
  freqs = seq(1, 200, by = 1),
  cycles = c(2, 20),
  target_sample_rate = 100
)

}


}
