% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groups.R
\name{search_groups}
\alias{search_groups}
\title{Search groups}
\usage{
search_groups(query = NULL, page = NULL, page_size = NULL,
  sort = NULL, ...)
}
\arguments{
\item{query}{search string}

\item{page}{result page to retrieve; defaults to first page}

\item{page_size}{number of results to retrieve; defaults to 50}

\item{sort}{options: `best`, `added`, `favorites`}

\item{...}{pass any other filter parameters available via \url{https://www.ravelry.com/groups/search}
(ex. creation, gc)}
}
\value{
tibble containing group information, like name, created_at, short_description, etc.
}
\description{
This function retrieves groups based on search terms.
}
\examples{
\dontrun{search_groups(query = 'star wars')}

# with site search parameters
\dontrun{search_groups(query = 'star wars', gc = 'knitting')}

}
