% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_resized.R
\name{render_resized}
\alias{render_resized}
\title{Resize Image}
\usage{
render_resized(
  image,
  mag = 1,
  dims = NULL,
  filename = NULL,
  preview = FALSE,
  method = "tri"
)
}
\arguments{
\item{image}{Image filename, 3-layer RGB array, or matrix.}

\item{mag}{Default \code{1}. Amount to magnify the image, preserving aspect ratio. Overridden if
\code{dim} is not \code{NULL}.}

\item{dims}{Default \code{NULL}. Exact resized dimensions.}

\item{filename}{Default \code{NULL}. The filename of the image to be saved. If this is not given, the image will be plotted instead.}

\item{preview}{Default \code{FALSE}. Whether to plot the convolved image, or just to return the values.}

\item{method}{Default \code{trilinear}. Filters to up/downsample the image. Options: \code{bilinear}, \code{box}, \code{trilinear},
\code{catmull}, \code{mitchell}.}
}
\value{
3-layer RGB resized array or matrix.
}
\description{
Resizes an image or a matrix, using bilinear interpolation.
}
\examples{
if(run_documentation()){
#Plot the image with a title
dragon |>
 render_title("Dragon", title_offset=c(10,10), title_bar_color="black",
           title_size=20, title_color = "white") |>
 plot_image()
}
if(run_documentation()){
#Half of the resolution
render_resized(dragon, mag = 1/2) |>
 render_title("Dragon (half res)", title_offset=c(5,5), title_bar_color="black",
           title_size=10, title_color = "white") |>
 plot_image()
}
if(run_documentation()){
#Double the resolution
render_resized(dragon, mag = 2) |>
 render_title("Dragon (2x res)", title_offset=c(20,20), title_bar_color="black",
           title_size=40, title_color = "white") |>
 plot_image()
}
if(run_documentation()){
#Specify the exact resulting dimensions
render_resized(dragon, dim = c(320,160)) |>
 render_title("Dragon (custom size)", title_offset=c(10,10), title_bar_color="black",
           title_size=20, title_color = "white") |>
 plot_image()
}
}
