% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download-marketdata.R
\name{download_marketdata}
\alias{download_marketdata}
\title{Download Raw Market Data Files from B3}
\usage{
download_marketdata(meta)
}
\arguments{
\item{meta}{A metadata object.}
}
\value{
Returns a meta object containing the downloaded file's metadata:
\itemize{
\item template - Name of the template used
\item download_checksum - Unique hash code for the download
\item download_args - Arguments used for the download
\item downloaded - Path to the downloaded file
\item created - Timestamp of file creation
\item is_downloaded - Whether the file was successfully downloaded
\item is_processed - Whether the file was successfully processed
\item is_valid - Whether the file is valid
}

The \code{meta} object can be interpreted as a ticket for the download process.
It contains all the necessary information to identify the data, if it has been
downloaded, if it has been processed, and ince it is processed,
if the downloaded file is valid.
}
\description{
Downloads and caches financial market datasets from B3 (Brazilian Stock Exchange)
based on predefined templates. Handles file downloading and caching.
}
\details{
The function follows this workflow:
\enumerate{
\item Checks if requested data exists in cache
\item Downloads data if needed (based on template specifications)
\item Manages file compression and storage
\item Maintains metadata for tracking and verification
}

Files are organized in the \code{rb3.cachedir} as follows:
\itemize{
\item Data: Gzipped files in 'raw/' directory, named by file's checksum
}

Templates are YAML documents that define:
\itemize{
\item Download parameters and methods
\item Data reading instructions
\item Dataset structure (columns, types)
}

Templates can be found using \code{list_templates()} and retrieved with \code{template_retrieve()}.
}
\examples{
\dontrun{
# Create metadata for daily market data
meta <- template_meta_create_or_load("b3-cotahist-daily",
  refdate = as.Date("2024-04-05")
)
# Download using the metadata
meta <- download_marketdata(meta)

# For reference rates
meta <- template_meta_create_or_load("b3-reference-rates",
  refdate = as.Date("2024-04-05"),
  curve_name = "PRE"
)
# Download using the metadata
meta <- download_marketdata(meta)
}

}
\seealso{
\itemize{
\item \code{\link{template_meta_create_or_load}} for creating a metadata object
\item \code{\link{list_templates}} for listing available data templates
\item \code{\link{template_retrieve}} for retrieving specific template details
}

\code{\link{read_marketdata}}, \code{\link{rb3.cachedir}}
}
