% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rb3-package.R
\name{rb3.cachedir}
\alias{rb3.cachedir}
\title{\code{rb3.cachedir} Option}
\description{
The \code{rb3.cachedir} option is used to specify the directory where cached data
will be stored when using the \code{rb3} package. This option allows users to
define a custom directory for caching, which can improve performance by
avoiding repeated downloads or computations.
}
\details{
\subsection{Setting the \code{rb3.cachedir} Option}{

To set the \code{rb3.cachedir} option, use the \code{options()} function and provide
the desired directory path as a string. For example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Set the cache directory to a custom path
options(rb3.cachedir = "/path/to/your/cache/directory")
}\if{html}{\out{</div>}}

Replace \code{"/path/to/your/cache/directory"} with the actual path where you want
the cached data to be stored.
}

\subsection{Viewing the Current Value of \code{rb3.cachedir}}{

To check the current value of the \code{rb3.cachedir} option, use the \code{getOption()}
function:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# View the current cache directory
getOption("rb3.cachedir")
}\if{html}{\out{</div>}}

This will return the path to the directory currently set for caching, or
\code{NULL} if the option has not been set.
}

\subsection{Notes}{
\itemize{
\item Ensure that the specified directory exists and is writable.
\item If the \code{rb3.cachedir} option is not set, the package use a temporary directory (\code{base::tempdir()}).
}
}
}
\examples{
# Set the cache directory
options(rb3.cachedir = "~/rb3_cache")

# Verify the cache directory
cache_dir <- getOption("rb3.cachedir")
print(cache_dir)

# In this example, the cache directory is set to `~/rb3_cache`, and the value 
# is then retrieved and printed to confirm the setting.

}
