% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accrate.R
\name{accrates.core}
\alias{accrates.core}
\title{Provide a summary of the estimated accumulation rates for a range of core depths}
\usage{
accrates.core(
  dseq = c(),
  set = get("info"),
  cmyr = FALSE,
  na.rm = FALSE,
  probs = c(0.025, 0.16, 0.84, 0.975, 0.5),
  round = 2,
  write = TRUE,
  sep = "\\t"
)
}
\arguments{
\item{dseq}{The sequence of depths for which accumulation rates need to be returned. Defaults to whatever info$dseq is, which most often is a sequence from the top to the bottom of the core at 1 cm increments.}

\item{set}{Detailed information of the current run, stored within this session's memory as variable \code{info}.}

\item{cmyr}{Accumulation rates can be calculated in cm/year or year/cm. By default \code{cmyr=FALSE} and accumulation rates are calculated in year per cm.}

\item{na.rm}{Remove NA entries. These are NOT removed by default, so that always the same amount of iterations is returned.}

\item{probs}{The probability ranges to be returned. Defaults to the minima and maxima of the 95\% and 68\% ranges, as well as the median: \code{probs=c(.025, .16, .84, .975, .5)}.}

\item{round}{The number of decimals to report. Defaults to \code{round=2}.}

\item{write}{Whether or not to write the summary to a file, in the core's directory and ending in `_accrates.txt`.}

\item{sep}{Character to separate the entries within the file. Defaults to a tab, \code{sep="\t"}.}
}
\value{
A summary of the estimated accumulation rate for all selected depths: minimum of the 95\% interval, minimum of the 68\% interval, maximum of the 68\% interval, maximum of the 95\% interval, median (i.e., 50\%) and mean. This is optionally written to a file in the core directory.
}
\description{
Obtain a summary (95\% range, 68\% range, median, mean) of the accumulation rates (in years per cm, so actually sedimentation times) as estimated by the MCMC iterations for a range of depths of a core, and optionally write this as a file to the core directory (ending in '_accrates.txt').
}
\examples{
\dontrun{
  Bacon(run=FALSE, coredir=tempfile())
  agedepth(yr.res=50, d.res=50, d.by=10)
  myaccrates <- accrates.core()
}
}
\author{
Maarten Blaauw
}
