% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binarize_with_thr.R
\name{binarize_with_thr}
\alias{binarize_with_thr}
\title{Binarize with known thresholds}
\usage{
binarize_with_thr(r, thr)
}
\arguments{
\item{r}{numeric \link[terra:SpatRaster-class]{terra::SpatRaster} with one layer.}

\item{thr}{either a numeric vector of length one (for global thresholding) or
a numeric \link[terra:SpatRaster-class]{terra::SpatRaster} with one layer (for local thresholding).}
}
\value{
Logical \link[terra:SpatRaster-class]{terra::SpatRaster} (\code{TRUE} for sky, \code{FALSE} for
non-sky) with the same dimensions as \code{r}.
}
\description{
Apply a threshold or a raster of thresholds to a grayscale image, producing a
binary image.
}
\details{
This function supports both global and pixel-wise thresholding. It is a
wrapper around the \code{>} operator from the \code{terra} package. If a single numeric
threshold is provided via \code{thr}, it is applied globally to all pixels in \code{r}.
If instead a \link[terra:SpatRaster-class]{terra::SpatRaster} object is provided, local thresholding
is performed, where each pixel is compared to its corresponding threshold
value.

This is useful after estimating thresholds using \code{\link[=thr_twocorner]{thr_twocorner()}},
\code{\link[=thr_isodata]{thr_isodata()}}, or
\code{apply_by_direction(method = "thr_isodata")}, among other posibilities.
}
\note{
For global thresholding, \code{thr} must be greater than or equal to the minimum
value of \code{r} and lower than its maximum value.
}
\examples{
r <- read_caim()
bin <- binarize_with_thr(r$Blue, thr_isodata(r$Blue[]))
plot(bin)

\dontrun{
# This function is also compatible with thresholds estimated using
# the 'autothresholdr' package:
require(autothresholdr)
r <- r$Blue
r <- normalize_minmax(r) \%>\% multiply_by(255) \%>\% round()
thr <- auto_thresh(r[], "IsoData")[1]
bin <- binarize_with_thr(r, thr)
plot(bin)
}
}
