% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_feature.R
\name{extract_feature}
\alias{extract_feature}
\title{Extract feature}
\usage{
extract_feature(
  r,
  segmentation,
  fun = mean,
  return = "raster",
  ignore_label_0 = TRUE
)
}
\arguments{
\item{r}{numeric \link[terra:SpatRaster-class]{terra::SpatRaster} with one layer.}

\item{segmentation}{single-layer \link[terra:SpatRaster-class]{terra::SpatRaster}. Segmentation map
of r, typically created with functions such as \code{\link[=sky_grid_segmentation]{sky_grid_segmentation()}},
\code{\link[=ring_segmentation]{ring_segmentation()}} or \code{\link[=sector_segmentation]{sector_segmentation()}}, but any raster with
integer segment labels is accepted.}

\item{fun}{function taking a numeric/logical vector and returning a single
numeric or logical value (default \code{mean}).}

\item{return}{character of length one. Either \code{"raster"} (default) or
\code{"vector"}, controlling whether to return a map with per-segment values or
a named vector (one value per segment).}

\item{ignore_label_0}{logical of length one. If \code{TRUE}, the segment labeled
\code{0} is ignored.}
}
\value{
If \code{return = "raster"}, a \link[terra:SpatRaster-class]{terra::SpatRaster} where each pixel
holds its segment’s feature value. If \code{return = "vector"}, a named numeric
(or logical) vector with one value per segment.
}
\description{
Extract a numeric or logical summary from segmented raster
regions using a user-defined reducer, returning one value per segment as a
raster map or a named vector.
}
\details{
Segments labeled \code{0} can be ignored via \code{ignore_label_0 = TRUE}. The
function in \code{fun} must return a single numeric or logical value for any input
vector (e.g., \code{mean}, \code{median}, or a custom reducer).
}
\examples{
r <- read_caim()
z <- zenith_image(ncol(r),lens())
a <- azimuth_image(z)
g <- sky_grid_segmentation(z, a, 10)
print(extract_feature(r$Blue, g, return = "vector"))
# plot(extract_feature(r$Blue, g, return = "raster"))
}
