% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{binMed}
\alias{binMed}
\title{Computes the median date of each bin}
\usage{
binMed(x, bins, verbose = TRUE)
}
\arguments{
\item{x}{A \code{CalDates} class object.}

\item{bins}{vector containing the bin names associated with each radiocarbon date. Can be generated using \code{\link[rcarbon]{binPrep}}.}

\item{verbose}{A logical variable indicating whether extra information on progress should be reported. Default is TRUE.}
}
\value{
A vector of median dates in cal BP
}
\description{
Function for generating a vector of median calibrated dates for each each bin.
}
\examples{
\dontrun{
#Load EUROEVOL Data
data(euroevol)
#Subset Danish Dates
denmark <- subset(euroevol,Country=="Denmark")
#Calibrate and Bin
denmarkDates <- calibrate(x=denmark$C14Age,errors=denmark$C14SD) 
denmarkBins <- binPrep(sites=denmark$SiteID,ages=denmark$C14Age,h=200) #200 years bin size
#Compute median date for each bin
binMed(x=denmarkDates,bins=denmarkBins)
}
}
\seealso{
\code{\link[rcarbon]{binPrep}},\code{\link[rcarbon]{barCodes}}
}
