#' @keywords internal
"_PACKAGE"

#' Collection of Data Sets Containing ADHD Related Data
#'
#' A collection of data sets relating to ADHD (Attention Deficit
#' Hyperactivity Disorder) which have been sourced from other packages on CRAN
#' or from publications on other websites such as Kaggle
#' <http://www.kaggle.com/>. The package also includes some simple functions for
#' analysing data sets. The data sets and descriptions of the data sets may
#' differ from what is on CRAN or other source websites. The aim of this package
#' is to bring together data sets from a variety of ADHD research publications.
#' This package would be useful for those interested in finding out what
#' research has been done on the topic of ADHD, or those interested in comparing
#' the results from different existing works. I started this project because I
#' wanted to put together a collection of the data sets relevant to ADHD
#' research, which I have a personal interest in. This work was conducted with
#' the support of my mentor within the Global Talent Mentoring platform.
#' <https://globaltalentmentoring.org/>.
#'
#' @name rcollectadhd
#'
#' @seealso `{BFpack}`, `{welchADF}`, `{DoubleCone}`, `{psymetadata}`,
#' `{DTRlearn2}`
NULL
