% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wt_kern_bivariate.R
\name{wt_kern_bivariate}
\alias{wt_kern_bivariate}
\title{Bivariate Kernel Weight Calculation}
\usage{
wt_kern_bivariate(
  X1,
  X2,
  center1,
  center2,
  bw,
  kernel = "triangular",
  t.design = NULL
)
}
\arguments{
\item{X1}{The input x1 values for the first vector. 
This variable represents the axis along which kernel weighting should be performed;
the first assignment variable in an MRDD.}

\item{X2}{The input x2 values for the second vector. \code{X2} has the same length as \code{X1}.
This variable represents the axis along which kernel weighting should be performed.;
the second assignment variable in an MRDD.}

\item{center1}{A numeric value specifying the point from which distances should be calculated for the first vector, \code{X1}.}

\item{center2}{A numeric value specifying the point from which distances should be calculated for the second vector, \code{X2}.}

\item{bw}{A numeric vector specifying the bandwidths for each of three effects models 
(complete model, heterogeneous treatment model, and treatment only model) 
detailed in Wong, Steiner, and Cook (2013).}

\item{kernel}{A string indicating which kernel to use. Options are \code{"triangular"} 
(default and recommended), \code{"rectangular"}, \code{"epanechnikov"}, \code{"quartic"}, 
\code{"triweight"}, \code{"tricube"}, and \code{"cosine"}.}

\item{t.design}{A character vector of length 2 specifying the treatment option according to design.
The first entry is for \code{x1} and the second entry is for \code{x2}. Options are  
\code{"g"} (treatment is assigned if \code{x1} is greater than its cutoff),
\code{"geq"} (treatment is assigned if \code{x1} is greater than or equal to its cutoff),
\code{"l"} (treatment is assigned if \code{x1} is less than its cutoff),
and \code{"leq"} (treatment is assigned if \code{x1} is less than or equal to its cutoff).
The same options are available for \code{x2}.}
}
\value{
\code{wt_bivariate_kern} returns a matrix of weights and distances with length equal to that of the \code{X1} and \code{X2} input.
  The first and second weights and distances are calculated with respect to all frontiers of different treatments.
  The third weight and distance are calculated with respect to the overall frontier of treatment versus
  non-treatment.
}
\description{
\code{wt_kern_bivariate} calculates the appropriate weights for two variables for
   Multivariate Frontier Regression Discontinuity Estimation with nonparametric implementation.
   Kernel weights are calculated based on the L1 distance of the two variables from the frontiers.
   This is an internal function and is typically not directly invoked by the user.
   It can be accessed using the triple colon, as in rddapp:::wt_kern_bivariate().
}
