% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdbwhte.R
\name{rdbwhte}
\alias{rdbwhte}
\title{Data-Driven Optimal Bandwidth Selection for RD Heterogeneous Treatment
Effects Estimation}
\usage{
rdbwhte(
  y,
  x,
  c = 0,
  covs.hte = NULL,
  covs.eff = NULL,
  p = 1,
  q = 2,
  kernel = "tri",
  vce = "hc3",
  cluster = NULL,
  bwselect = "mserd",
  bw.joint = FALSE
)
}
\arguments{
\item{y}{Outcome variable.}

\item{x}{Running variable.}

\item{c}{RD cutoff in \code{x}; default is \code{c = 0}.}

\item{covs.hte}{covariates for heterogeneous treatment effects. Factor variables can be used to distinguish between continuous and categorical variables, select reference categories, specify interactions between variables, and include polynomials of continuous variables.}

\item{covs.eff}{additional covariates to be used for efficiency improvements.}

\item{p}{order of the local polynomial used to construct the point estimator (default = 1).}

\item{q}{order of the local polynomial used to construct the bias correction  (default = 2).}

\item{kernel}{kernel function used to construct the RD estimators. Options are \code{triangular} (default option), \code{epanechnikov} and \code{uniform}.}

\item{vce}{character string specifying the variance-covariance matrix estimator type (hc0–hc3) (default = "hc3").}

\item{cluster}{variable indicating the clustering of observations.}

\item{bwselect}{bandwidth selection procedure to be used.
Options are:
\code{mserd} one common MSE-optimal bandwidth selector for the RD treatment effect estimator.
\code{msetwo} two different MSE-optimal bandwidth selectors (below and above the cutoff) for the RD treatment effect estimator.
\code{msesum} one common MSE-optimal bandwidth selector for the sum of regression estimates (as opposed to difference thereof).
\code{msecomb1} for min(\code{mserd},\code{msesum}).
\code{msecomb2} for median(\code{msetwo},\code{mserd},\code{msesum}), for each side of the cutoff separately.
\code{cerrd} one common CER-optimal bandwidth selector for the RD treatment effect estimator.
\code{certwo} two different CER-optimal bandwidth selectors (below and above the cutoff) for the RD treatment effect estimator.
\code{cersum} one common CER-optimal bandwidth selector for the sum of regression estimates (as opposed to difference thereof).
\code{cercomb1} for min(\code{cerrd},\code{cersum}).
\code{cercomb2} for median(\code{certwo},\code{cerrd},\code{cersum}), for each side of the cutoff separately.
Note: MSE = Mean Square Error; CER = Coverage Error Rate. Default is \code{bwselect=mserd}.}

\item{bw.joint}{logical. If \code{TRUE}, forces all bandwidths to be the same across groups (default is \code{bw.joint = FALSE}).}
}
\value{
A list with selected bandwidths and model information.
\item{W.lev}{vector of group level identifiers.}
\item{kernel}{kernel type used.}
\item{vce}{variance estimator used.}
\item{c}{cutoff value.}
\item{h}{vector containing the bandwidths used.}
\item{p}{order of the polynomial used for estimation.}
\item{q}{order of the polynomial used for inference.}
\item{N}{vector with the original number of observations for each group.}
\item{Nh}{vector with the effective number of observations for each group.}
\item{covs.cont}{internal value.}
\item{rdmodel}{rd model.}
}
\description{
\code{rdbwhte} computes MSE- and CER-optimal bandwidths for estimating
RD heterogeneous treatment effects based on covariates.

Companion commands: \code{\link{rdhte}} for RD HTE estimation and inference,
and \code{\link{rdhte_lincom}} for testing linear restrictions of parameters.

Related Stata and R packages useful for inference in RD designs are
described in the website: \url{https://rdpackages.github.io/}.
}
\examples{
set.seed(123)
n <- 5000
X <- runif(n, -1, 1)
W <- rbinom(n, 1, 0.5)
Y <- 3 + 2*X + 1.5*X^2 + 0.5*X^3 + sin(2*X) + 3*W*(X>=0) + rnorm(n)
rdbwhte.1 = rdbwhte(y=Y, x=X, covs.hte=factor(W))
summary(rdbwhte.1)
}
\references{
Calonico, Cattaneo, Farrell, Palomba and Titiunik (2025): rdhte: Learning Conditional Average Treatment Effects in RD Designs. \emph{Working paper}.

Calonico, Cattaneo, Farrell, Palomba and Titiunik (2025): Treatment Effect Heterogeneity in Regression Discontinuity Designs. \emph{Working paper}
}
\seealso{
\code{\link{rdhte}}, \code{\link{rdhte_lincom}}
}
\author{
Sebastian Calonico, University of California, Davis \email{scalonico@ucdavis.edu}.

Matias D. Cattaneo, Princeton University  \email{cattaneo@princeton.edu}.

Max H. Farrell, University of California, Santa Barbara \email{maxhfarrell@ucsb.edu}.

Filippo Palomba, Princeton University \email{fpalomba@princeton.edu}.

Rocio Titiunik, Princeton University \email{titiunik@princeton.edu}.
}
