% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readDWD.R
\name{readDWD.deriv}
\alias{readDWD.deriv}
\title{read derived dwd data}
\usage{
readDWD.deriv(file, gargs = NULL, todate = TRUE, quiet = rdwdquiet(), ...)
}
\arguments{
\item{file}{Name of file on harddrive, like e.g.
DWDdata/soil_daily_historical_derived_germany_soil_daily_historical_3987.txt.gz}

\item{gargs}{If fread=FALSE: Named list of arguments passed to
\code{\link[R.utils:compressFile]{R.utils::gunzip()}}, see \code{\link[=readDWD.raster]{readDWD.raster()}}. DEFAULT: NULL}

\item{todate}{Logical: Convert char column 'Datum' or 'Monat' with \code{\link[=as.Date]{as.Date()}}?
The format is currently hard-coded. Monthly data gets mapped to yyyy-mm-15
DEFAULT: TRUE}

\item{quiet}{Ignored.
DEFAULT: FALSE through \code{\link[=rdwdquiet]{rdwdquiet()}}}

\item{\dots}{Further arguments passed to \code{\link[=read.table]{read.table()}} or \code{\link[data.table:fread]{data.table::fread()}}}
}
\value{
data.frame
}
\description{
Read dwd data from /CDC/derived_germany/.
Intended to be called via \code{\link[=readDWD]{readDWD()}}.
}
\seealso{
\code{\link[=readDWD]{readDWD()}}, https://brry.github.io/rdwd/use-case-derived-data.html
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}
}
