% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_apra.R
\name{download_apra}
\alias{download_apra}
\title{Download a Statistical Publication File from APRA's Website}
\usage{
download_apra(
  stat_pub,
  cur_hist = "current",
  path = tempdir(),
  overwrite = TRUE,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{stat_pub}{character vector detailing a statistical publication to be
downloaded. Must match a valid value in the
\code{apra_stat_pubs_acronym} variable of the \link{apra_stat_pubs} dataset.}

\item{cur_hist}{character vector detailing whether to download a current
or historic statistical publication. Must match a
valid value in the \code{cur_hist} variable of the \link{apra_stat_pubs}
dataset.}

\item{path}{path to where the downloaded file should be saved. Uses
\code{\link[base:tempfile]{base::tempdir()}} by default.}

\item{overwrite}{whether to overwrite a previously downloaded statistical
publication file when re-running this function.}

\item{quiet}{whether to suppress the download progress bar.}

\item{...}{additional arguments to be passed to \code{\link[utils:download.file]{utils::download.file()}}.}
}
\value{
A character vector detailing the file path to the downloaded file.
}
\description{
Download a statistical publication file from APRA's website. By
default files are saved to a temporary directory.
}
\examples{
\donttest{
# Download a statistical publication file:
download_path <-
  download_apra(stat_pub = "qadips", cur_hist = "current")

# View the file path of the statistical publication file:
print(download_path)
}

}
