% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readmission.R
\docType{data}
\name{readmission}
\alias{readmission}
\title{Hospital Readmission Data for Patients with Diabetes}
\format{
A data frame with 71,515 rows and 12 columns:
\describe{
\item{readmitted}{Whether the patient was readmitted within the 30 days
following discharge. A factor with levels \code{"Yes"} and \code{"No"}.}
\item{race}{Reported race of the patient. Source data does not document
data collection strategy. A factor with levels \code{"African American"},
\code{"Asian"}, \code{"Caucasian"}, \code{"Hispanic"}, \code{"Other"}, and \code{"Unknown"}.}
\item{sex}{Reported sex of the patient. Source data does not document
data collection strategy. A factor with levels \code{"Female"} and \code{"Male"}.}
\item{age}{Age range for the patient, binned in 10-year intervals. A factor
with levels \code{"[0-10)"}, \code{"[10-20)"}, \code{"[20-30)"}, \code{"[30-40)"}, \code{"[40-50)"},
\code{"[50-60)"}, \code{"[60-70)"}, \code{"[70-80)"}, \code{"[80-90)"}, and \code{"[90-100)"}.}
\item{admission_source}{Whether the patient was referred from a physician,
admitted via the ER, or arrived via some other source. A factor with
levels \code{"Emergency"}, \code{"Other"}, and \code{"Referral"}.}
\item{blood_glucose}{Results from an A1C test, estimating the
patient's average blood sugar over the past 2-3 months. Higher estimated
average blood glucose levels are linked to diabetes complications. A factor
with levels \code{"Normal"}, \code{"High"}, and \code{"Very High"}, and many missing values.}
\item{insurer}{The health insurance provider (or lack thereof,
via \code{"Self-Pay"}) for the patient. A factor with levels
\code{"Medicaid"}, \code{"Medicare"}, \code{"Private"}, and \code{"Self-Pay"}, and many missing
values.}
\item{duration}{Number of days in the hospital between admission and
discharge.}
\item{n_previous_visits}{Number of emergency, inpatient, and outpatient
visits in the year preceding the encounter.}
\item{n_diagnoses}{"Number of diagnoses entered to the system" during
the encounter.}
\item{n_procedures}{"Number of procedures (other than lab tests)
performed" during the encounter.}
\item{n_medications}{"Number of distinct generic names administered"
during the encounter.}
}
}
\source{
\emph{Original source data from the following paper (CC BY 3.0):}

Strack, B., DeShazo, J. P., Gennings, C., Olmo, J. L., Ventura, S., Cios,
K. J., & Clore, J. N. 2014. Impact of HbA1c measurement on hospital
readmission rates: analysis of 70,000 clinical database patient records.
BioMed research international, 781670. \url{doi:10.1155/2014/781670}.

\emph{Shared freely through the UCI Machine Learning Repository (CC BY 4.0):}

Clore, J., Cios, K., DeShazo, J. P., and Strack, B. 2014. Diabetes 130-US
hospitals for years 1999-2008. UCI Machine Learning Repository.
\url{doi:10.24432/C5230J}.

\emph{Downloaded from resources shared by the Fairlearn team (MIT):}

Weerts, H., Dudík M., Edgar, R., Jalali, A., Lutz, R., & Madaio, M. 2023.
Fairlearn: Assessing and Improving Fairness of AI Systems. Journal of
Machine Learning Research, 24(257):1-8.
}
\usage{
readmission
}
\description{
Clinical care data from 130 U.S. hospitals in years 1999-2008.
Each row describes an "encounter" with a patient with diabetes, including
variables on demographics, medications, patient history, diagnostics,
payment, and readmission.
}
\examples{

str(readmission)

head(readmission)

}
\keyword{datasets}
