% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{cv_adj}
\alias{cv_adj}
\title{Find the adjusted coefficient of variation}
\usage{
cv_adj(qual, result, nd = c("<", "nd", "ND"), nd_adjustment = 0.5)
}
\arguments{
\item{qual}{A character vector containing non-detect indicator strings, e.g., "<" or "ND". The strings used to indicate censored status can be edited in the "nd" argument.}

\item{result}{A numeric vector of concentration measurements.}

\item{nd}{A list indicating all the censoring flags included in the dataset. Defaults to "<", "nd", and "ND".}

\item{nd_adjustment}{Adjustment factor for non-detect values. Non-detect values (as indicated in qual vector) are multiplied by nd_adjustment factor; i.e. result * nd_adjustment. Typically, method detection limits or reporting limits are used as result values for non-detects.}
}
\value{
A numeric coefficient of variation (CV) value
}
\description{
Calculates adjusted coefficient of variation (CV) according to methods described in EPA's Technical Support Document for Water Quality-based Toxics Control.
}
\examples{
# CV for all detected values 
cen_result <- rep("", 10)
result     <- c(1:10) 
cv_adj(cen_result, result)

# CV for all non-detected values
cen_result <- rep("<", 10)
cv_adj(cen_result, result)

# CV for fewer than 10 measurements
cen_result <- rep("", 5)
result <-     c(1:5)
cv_adj(cen_result, result)

# Change the default substitution value
cen_result <- c(rep("<", 5), rep("", 15))
result     <- c(101:120)
cv_adj(cen_result, result)   # Use default 0.5 multiplier
# Use 1.0 multiplier (equivalent to using MDL)
cv_adj(cen_result, result, nd_adjustment = 1.0)  
# Use 0.0 multiplier (equivalent to zero substitution)
cv_adj(cen_result, result, nd_adjustment = 0)  
}
