#' Distribuția numărului de ore/zi la o clasă
#'
#' Pentru a vedea dacă la o anumită clasă, putem muta o lecție într-o altă zi,
#' fără ca prin aceasta să afectăm omogenitatea distribuției lecțiilor ei.
#'
#' @param DZ Distribuția curentă a tuturor lecțiilor
#' @param K Clasa 
#' @return Distribuția pe zile a numărului de lecții ale clasei 
#' @export
#'
cls_dis <- function(DZ, K) {
    D <- filter(DZ, .data$cls == K)
    table(D$zl)
}
