#' mapează 'cls2prof()' pe lista acelor profesori P1 din afara cuplajelor 
#' cu care profesorul indicat ar putea schimba o clasă și o zi, fără ca 
#' prin aceasta distribuția lui P1 să fie "degradată" (să devină neomogenă)
#' 
#' Pentru interschimbare, este de ales o clasă la care cei doi profesori au oră
#' numai în una, dintre cele două zile și astfel încât măcar una dintre
#' distribuții să devină omogenă (cealaltă poate să rămână cvasi-omogenă).
#'
#' @param DZ Distribuția curentă a lecțiilor, pe zile
#' @param P Profesorul căruia am vrea să-i omogenizăm distribuția
#' @param z1,z2 Zilele (în termenii din 'Zile') între care am schimba 
#' @return Lista distribuțiilor profesorilor cu care se poate interschimba
#' @export
#' 
prof_swap <- function(DZ, P, z1, z2) {
    stopifnot("z1 and z2 must be in 'Zile'"=all(c(z1,z2) %in% Zile))
    LS <- DZ[DZ$prof == P, ] %>% as.data.frame()
    C1 <- LS[LS$zl == z1, 2] # clasele lui P în ziua z1
    C2 <- LS[LS$zl == z2, 2] # clasele lui P în ziua z2
    if(is.null(cache_env$prof1))
        set_prof1_tw1(DZ)
    Profs <- cache_env$prof1  # profesorii neimplicați în cuplaje
    map(setdiff(Profs, P), function(P1) {
        DS <- DZ[DZ$prof == P1, ] %>% as.data.frame()
        K2 <- DS[DS$zl == z2, 2] # clasele lui P1 în ziua z2
        K1 <- DS[DS$zl == z1, 2] # clasele lui P1 în ziua z1
       if(length(K2) <= length(K1)) return(NULL)
       if(! length(intersect(setdiff(C1, C2), setdiff(K2, K1))))
           return(NULL)
        cls2prof(DZ, P1) # returnează distribuția claselor lui P1
    }) %>% compact()
}


