% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backgroundCondition.R
\name{backgroundCondition}
\alias{backgroundCondition}
\title{Generate a background condition for masking}
\usage{
backgroundCondition(
  lower = NULL,
  upper = NULL,
  center = NULL,
  radius = NULL,
  transparent = NULL,
  alpha_channel = FALSE,
  quietly = TRUE
)
}
\arguments{
\item{lower, upper}{RGB triplet ranges for setting a bounding box of pixels to mask.}

\item{center, radius}{RGB triplet and radius (as a proportion) for masking
pixels within a spherical range.}

\item{transparent}{Logical or \code{NULL}. Use transparency to mask? Requires an
alpha channel.}

\item{alpha_channel}{Logical. Is there an alpha channel?}

\item{quietly}{Logical. Print a message about background masking parameters?}
}
\value{
A list with background masking parameters. Can be one of 4 classes:
\enumerate{
\item \code{bg_rect}: If \code{lower} and \code{upper} are specified.
\item \code{bg_sphere}: If \code{center} and \code{radius} are specified.
\item \code{bg_t}: If \code{transparent} is \code{TRUE} and there is an alpha channel
with transparent pixels.
\item \code{bg_none}: If no background masking is specified (or transparency
was specified but there are no transparent pixels).
}
}
\description{
Internal function for parsing potential background conditions. Prioritizes
transparency masking if conflicting options are provided. See details.
}
\details{
Prioritizes transparency. If \code{transparency = TRUE} but other options (such as
\code{lower} and \code{upper}) are specified, then only transparent pixels will be masked.
If \code{transparency = TRUE} but there is no alpha channel (as in a JPEG image),
this flag is ignored and other options (\code{lower} and \code{upper} or \code{center} and \code{radius})
are used instead.

This is an internal convenience function sourced by \code{\link[=backgroundIndex]{backgroundIndex()}}.
}
\examples{

# masking a white background:
backgroundCondition(lower = rep(0.9, 3), upper = rep(1, 3), quietly = FALSE)

# masking transparent pixels:
backgroundCondition(transparent = TRUE, alpha_channel = TRUE, quietly = FALSE)

# oops, no alpha channel:
backgroundCondition(transparent = TRUE, alpha_channel = FALSE, quietly = FALSE)

# oops, no alpha channel, but with white background as a fallback:
backgroundCondition(lower = rep(0.9, 3), upper = rep(1, 3),
                    transparent = TRUE, alpha_channel = FALSE,
                    quietly = FALSE)

}
