% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reorder_colors.R
\name{match_colors}
\alias{match_colors}
\title{Reorder a color palette to best match a reference palette}
\usage{
match_colors(reference_palette, match_palette, plotting = FALSE)
}
\arguments{
\item{reference_palette}{The palette whose order to match. Either a character
vector of colors (hex codes or color names) or an nx3 matrix in \strong{sRGB
color space}.}

\item{match_palette}{The palette to reorder, same formats as
\code{reference_palette}}

\item{plotting}{Logical. Plot the ordered palettes?}
}
\value{
A vector of color orders for \code{match_palette}.
}
\description{
Often for batch processing purposes, it is important to ensure
that color centers fit using different methods are in the same
order. This function reorders a provided color palette (\code{match_palette})
according a provided reference palette (\code{reference_palette}) by minimizing
their overall distance using the
\href{https://en.wikipedia.org/wiki/Hungarian_algorithm}{Hungarian algorithm}
as implemented by \link[clue:solve_LSAP]{clue::solve_LSAP}.
}
\details{
If the color palettes are wildly different, the returned order may not be
especially meaningful.
}
\examples{
ref_palette <- c("mediumblue", "olivedrab", "tomato2", "beige", "chocolate4")
match_palette <- c("#362C34", "#E4D3A9", "#AA4E47", "#809C35", "#49468E")
match_colors(ref_palette, match_palette, plotting = TRUE)

}
\seealso{
\link{reorder_colors}
}
