% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recolorize_adjacency.R
\name{recolorize_adjacency}
\alias{recolorize_adjacency}
\title{Run \code{pavo}'s adjacency and boundary strength analysis on a \code{recolorize}
object}
\usage{
recolorize_adjacency(
  recolorize_obj,
  xscale = 1,
  coldist = "default",
  hsl = "default",
  ...
)
}
\arguments{
\item{recolorize_obj}{A \code{recolorize} object.}

\item{xscale}{The length of the x-axis, in preferred units. Passed to
\link[pavo:adjacent]{pavo::adjacent}.}

\item{coldist}{A \link[pavo:coldist]{pavo::coldist} object; otherwise, this argument
is ignored and a \code{coldist} object for human vision is calculated from
RGB colors converted to CIE Lab using \link{cielab_coldist}.}

\item{hsl}{A dataframe with \code{patch}, \code{hue}, \code{sat} and \code{lum} columns
specifying the HSL values for each color patch, to be
passed to \link[pavo:adjacent]{pavo::adjacent}. Otherwise, this argument
is ignored and HSL values are calculated for human vision from the RGB
colors in the \code{recolorize} object.}

\item{...}{Further arguments passed to \link[pavo:adjacent]{pavo::adjacent}.}
}
\value{
The results of \link[pavo:adjacent]{pavo::adjacent}; see that documentation
for the meaning of each specific value.
}
\description{
Run adjacency (Endler 2012) and boundary strength (Endler et al. 2018)
analysis directly on a \code{recolorize} object, assuming a human viewer
(i.e. using CIE Lab and HSL color distances that correspond to
perceptual distances of human vision). This is achieved by
converting the \code{recolorize} object to a \link[pavo:classify]{pavo::classify} object,
converting the colors to HSL space, and calculating a \link[pavo:coldist]{pavo::coldist} object
for CIE Lab color space before running \link[pavo:adjacent]{pavo::adjacent}.
}
\details{
Eventually, the plan is to incorporate more sophisticated
color models than using human perceptual color distances, i.e.
by allowing users to match color patches to spectra. However,
this does return reasonable and informative results so long as
human vision is an appropriate assumption for the image data.
}
\examples{
img <- system.file("extdata/chongi.png", package = "recolorize")
recolorize_obj <- recolorize(img, method = "k", n = 2)
recolorize_adjacency(recolorize_obj)

}
\seealso{
\link[pavo:adjacent]{pavo::adjacent}, \link{classify_recolorize}
}
