% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reorder_colors.R
\name{reorder_colors}
\alias{reorder_colors}
\title{Reorder colors in a recolorize object}
\usage{
reorder_colors(recolorize_obj, col_order, plotting = FALSE)
}
\arguments{
\item{recolorize_obj}{An object of class \code{recolorize}.}

\item{col_order}{A numeric vector of the length of the number of color
centers in the \code{recolorize} object specifying the order of the colors.}

\item{plotting}{Logical. Plot the results?}
}
\value{
A \code{recolorize} object.
}
\description{
Often for batch processing purposes, it is important to ensure
that color centers fit using different methods are in the same
order.
}
\details{
While you can manually specify the \code{col_order} vector, one way to
automatically order the colors according to an external color palette (as
might be needed for batch processing) is to use the \link{match_colors} function,
although it is recommended to double-check the results.
}
\examples{
img <- system.file("extdata/corbetti.png", package = "recolorize")
rc <- recolorize2(img, cutoff = 45)
ref_palette <- c("mediumblue", "olivedrab", "tomato2", "beige", "grey10")
col_order <- match_colors(ref_palette, rc$centers, plotting = TRUE)
rc2 <- reorder_colors(rc, col_order, plotting = FALSE)

# the colors are reordered, but not changed to match the reference palette:
plot(rc2)

# you can also change them to the reference palette:
rc2$centers <- t(grDevices::col2rgb(ref_palette) / 255)
plot(rc2)
}
