% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot-method}
\alias{plot-method}
\alias{plot,mcf.formula,missing-method}
\alias{plot,mcf.formula-method}
\alias{plot,mcf.rateReg,missing-method}
\alias{plot,mcf.rateReg-method}
\alias{plot,baseRate.rateReg,missing-method}
\alias{plot,baseRate.rateReg-method}
\alias{plot,mcfDiff,missing-method}
\alias{plot,mcfDiff-method}
\title{Plot Baseline Rate or Mean Cumulative Function (MCF)}
\usage{
\S4method{plot}{mcf.formula,missing}(
  x,
  y,
  lty,
  col,
  legendName,
  legendLevels,
  conf.int = FALSE,
  mark.time = FALSE,
  addOrigin = FALSE,
  ...
)

\S4method{plot}{mcf.rateReg,missing}(x, y, conf.int = FALSE, lty, col, ...)

\S4method{plot}{baseRate.rateReg,missing}(x, y, conf.int = FALSE, lty, col, ...)

\S4method{plot}{mcfDiff,missing}(
  x,
  y,
  lty,
  col,
  legendName,
  legendLevels,
  conf.int = TRUE,
  addOrigin = FALSE,
  ...
)
}
\arguments{
\item{x}{An object used to dispatch a method.}

\item{y}{An argument that should be missing and ignored now.  Its existence
is just for satisfying the definition of generaic function \code{plot}
in package \code{graphics} for methods' dispatching.}

\item{lty}{An optional numeric vector indicating line types specified to
different groups: 0 = blank, 1 = solid, 2 = dashed, 3 = dotted, 4 =
dotdash, 5 = longdash, 6 = twodash.}

\item{col}{An optional character vector indicating line colors specified to
different groups.}

\item{legendName}{An optional length-one charactor vector to specify the
name for grouping each unique row in \code{newdata}, such as "gender"
for "male" and "female". The default value is generated from the
\code{object}.}

\item{legendLevels}{An optional charactor vector to specify the levels for
each unique row in \code{newdata}, such as "treatment" and "control".
The default values are generated from the \code{object}.}

\item{conf.int}{A logical value indicating whether to plot confidence
interval.  The default value is \code{FALSE}.}

\item{mark.time}{A logical value with default value \code{FALSE}.  If
\code{TRUE}, each censoring time is marked by "+" on the MCF curves.
Otherwise, the censoring time would not be marked.}

\item{addOrigin}{A logical value indicating whether the MCF curves start
from origin time. The default value is \code{FALSE}.}

\item{...}{Other arguments for further usage.}
}
\value{
A \code{ggplot} object.
}
\description{
S4 class methods plotting sample MCF from data, estimated MCF, or estimated
baseline hazard rate function from a fitted model by using \code{ggplot2}
plotting system.  The plots generated are thus able to be further customized
properly.
}
\examples{
## See examples given in function mcf and rateReg.

}
\seealso{
\code{\link{mcf}} for estimation of MCF;
\code{\link{rateReg}} for model fitting.
}
