% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_3d_layers.R
\name{add_3d_surface}
\alias{add_3d_surface}
\title{Add 3D regression surface to a plot_ly object}
\usage{
add_3d_surface(
  p,
  model,
  data = NULL,
  ci = TRUE,
  surfacecolor = "blue",
  surfacecolor_ci = "grey",
  opacity = 0.5,
  ...
)
}
\arguments{
\item{p}{A plotly object.}

\item{model}{An lm or glm with exactly two x variables}

\item{data}{An optional dataframe to be used to estimate the regression surface.
By default, this will be the data used by the inherited plotly object.}

\item{ci}{An optional logical. Defaults to TRUE, showing the confidence intervals
of the predicted effects.}

\item{surfacecolor}{A color recognized by plotly. Used within the
colorscale parameter in add_trace. Defaults to 'blue'.}

\item{surfacecolor_ci}{A color recognized by plotly. Used within
the colorscale parameter in add_trace. Defaults to 'grey'.}

\item{opacity}{Sets the opacity of the surface. Defaults to 0.5.}

\item{...}{Arguments (i.e., attributes) passed along to the trace \code{type}.
See \code{\link[plotly:schema]{schema()}} for a list of acceptable attributes for a given trace \code{type}
(by going to \code{traces} -> \code{type} -> \code{attributes}). Note that attributes
provided at this level may override other arguments
(e.g. \code{plot_ly(x = 1:10, y = 1:10, color = I("red"), marker = list(color = "blue"))}).}
}
\value{
A plotly object with the regression surface added to the plot.
}
\description{
Add a 3 dimensional regression surface layer to a plot_ly object.
}
\details{
Note that the data used to estimate the regression surface in model must be
the same as the data called in plot_ly or specified by the argument \code{data}.

Additional plotly layers such as \code{add_markers()} can
be added to the plotly plot, but be aware that many plotly layers inherit the data from the prior layer.
As such, a function such as \code{add_markers()} may not work as intended if called after \code{add_3d_surface()}.

The surface can be built from either an lm or glm. For glms, testing has been primarily focused on
binomial and Gamma families.
}
\examples{
library(plotly)
mymodel <- lm(length ~ isFemale_num + isMale_num, data = hair_data)
p1 <- plot_ly(data = hair_data,
              x = ~isFemale_num,
              y = ~isMale_num,
              z = ~length )
add_3d_surface(p1, model = mymodel, data = hair_data)
}
