% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotForest}
\alias{plotForest}
\title{Forest plot of coefficients}
\usage{
plotForest(beta, stders)
}
\arguments{
\item{beta}{regression coefficients from each analysis}

\item{stders}{standard errors corresponding to betas}
}
\value{
Forest plot of effect sizes and standard errors
}
\description{
Forest plot of coefficients
}
\examples{
# Generate effects
library(mvtnorm)
library(clusterGeneration )

n = 4
Sigma = cov2cor(genPositiveDefMat(n)$Sigma)
beta = t(rmvnorm(1, rep(0, n), Sigma))
stders = rep(.1, n)	

# set names
rownames(Sigma) = colnames(Sigma) = LETTERS[1:n]
rownames(beta) = names(stders) = LETTERS[1:n]

# Run random effects meta-analysis,
# account for correlation 
RE2C( beta, stders, Sigma)

# Make plot
plotForest( beta, stders )

}
