% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ru_fillna.R
\name{ru_fillna}
\alias{ru_fillna}
\title{Fill NA values with specified values or zeros/blanks by default.}
\usage{
ru_fillna(dsetin, vars = NULL, fills = NULL)
}
\arguments{
\item{dsetin}{Incoming data frame to have labels added to columns.}

\item{vars}{Vector of variables to replace NA values.}

\item{fills}{Vector of fill values.}
}
\value{
The incoming data frame with the requested NA values replaced.
}
\description{
Pass in a data frame along with a vector of variables and a vector of fill values.  (Default fill is 0 for numeric and blank " " for character.)
}
\examples{
library(repfun)
repfun::ru_fillna(airquality, vars=c('Ozone','Solar.R'), fills=c(1111,2222)) \%>\% head(10)

}
\author{
Yongwei Wang, \email{yongwei.x.wang@viivhealthcare.com} \cr
Chris Rook, \email{cr883296@gmail.com}
}
