% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autosum.R
\name{m_summary}
\alias{m_summary}
\title{Output a table for multivariate or univariate regression models}
\usage{
m_summary(
  model,
  CIwidth = 0.95,
  digits = 2,
  vif = FALSE,
  whichp = "levels",
  for_plot = FALSE
)
}
\arguments{
\item{model}{model fit}

\item{CIwidth}{width for confidence intervals, defaults to 0.95}

\item{digits}{number of digits to round estimates to, does not affect p-values}

\item{vif}{boolean indicating if the variance inflation factor should be
included. See details}

\item{whichp}{string indicating whether you want to display p-values for
levels within categorical data ("levels"), global p values ("global"), or
both ("both"). Irrelevant for continuous predictors. When for_plot = TRUE,
global p values will be displayed in a separate column from p values.
If whichp = "levels", global p values will not be included in the outputted
table.}

\item{for_plot}{boolean indicating whether or not the function will be used
for plotting. Default is FALSE}
}
\description{
A dataframe corresponding to a univariate or multivariate regression
table. If for_plot = TRUE, estimates and confidence interval bounds will
also be displayed separately for easy plotting.
}
\details{
Global p-values are likelihood ratio tests for lm, glm and polr models. For
lme models an attempt is made to re-fit the model using ML and if,successful
LRT is used to obtain a global p-value. For coxph models the model is re-run
without robust variances with and without each variable and a LRT is
presented. If unsuccessful a Wald p-value is returned. For GEE and CRR models
Wald global p-values are returned. For negative binomial models a deviance
test is used.

If the variance inflation factor is requested (VIF=T) then a generalised VIF
will be calculated in the same manner as the car package.

As of R 4.4.0 the likelihood profiles are included in base R.

The number of decimals places to display the statistics can be changed with
digits, but this will not change the display of p-values. If more significant
digits are required for p-values then use tableOnly=TRUE and format as
desired.
}
\examples{
\dontrun{data("pembrolizumab")
uv_lm <- lm(age~sex,data=pembrolizumab)
m_summary(uv_lm, digits = 3, for_plot = FALSE)

mv_binom <- glm(orr~age+sex+cohort,family = 'binomial',data = pembrolizumab)
m_summary(mv_binom, whichp = "both", for_plot = TRUE)}
}
\keyword{internal}
