% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache-helpers.R, R/exportedMethods.R
\name{.sortDotsUnderscoreFirst}
\alias{.sortDotsUnderscoreFirst}
\alias{.orderDotsUnderscoreFirst}
\alias{ExportedMethods}
\alias{.tagsByClass}
\alias{.tagsByClass,ANY-method}
\alias{.cacheMessage}
\alias{.cacheMessage,ANY-method}
\alias{.cacheMessageObjectToRetrieve}
\alias{.addTagsToOutput}
\alias{.addTagsToOutput,ANY-method}
\alias{.preDigestByClass}
\alias{.preDigestByClass,ANY-method}
\alias{.checkCacheRepo}
\alias{.checkCacheRepo,ANY-method}
\alias{.prepareOutput}
\alias{.prepareOutput,ANY-method}
\alias{.addChangedAttr}
\alias{.addChangedAttr,ANY-method}
\alias{updateFilenameSlots}
\alias{updateFilenameSlots.default}
\alias{updateFilenameSlots.list}
\alias{updateFilenameSlots.environment}
\alias{makeMemoisable}
\alias{makeMemoisable.default}
\alias{makeMemoisable.data.table}
\alias{unmakeMemoisable}
\alias{unmakeMemoisable.default}
\title{Exported generics and methods}
\usage{
.sortDotsUnderscoreFirst(obj)

.orderDotsUnderscoreFirst(obj)

.tagsByClass(object)

\S4method{.tagsByClass}{ANY}(object)

.cacheMessage(
  object,
  functionName,
  fromMemoise = getOption("reproducible.useMemoise", TRUE),
  verbose = getOption("reproducible.verbose", 1)
)

\S4method{.cacheMessage}{ANY}(
  object,
  functionName,
  fromMemoise = getOption("reproducible.useMemoise", TRUE),
  verbose = getOption("reproducible.verbose", 1)
)

.cacheMessageObjectToRetrieve(
  functionName,
  fullCacheTableForObj,
  cachePath = getOption("reproducible.cachePath"),
  cacheId = NULL,
  cacheSaveFormat = getOption("reproducible.cacheSaveFormat"),
  verbose
)

.addTagsToOutput(object, outputObjects, FUN, preDigestByClass)

\S4method{.addTagsToOutput}{ANY}(object, outputObjects, FUN, preDigestByClass)

.preDigestByClass(object)

\S4method{.preDigestByClass}{ANY}(object)

.checkCacheRepo(
  object,
  create = FALSE,
  verbose = getOption("reproducible.verbose", 1)
)

\S4method{.checkCacheRepo}{ANY}(
  object,
  create = FALSE,
  verbose = getOption("reproducible.verbose", 1)
)

.prepareOutput(object, cachePath = getOption("reproducible.cachePath"), ...)

\S4method{.prepareOutput}{ANY}(object, cachePath = getOption("reproducible.cachePath"), ...)

.addChangedAttr(object, preDigest, origArguments, ...)

\S4method{.addChangedAttr}{ANY}(object, preDigest, origArguments, ...)

updateFilenameSlots(obj, curFilenames, newFilenames, isStack = NULL)

\method{updateFilenameSlots}{default}(obj, curFilenames, newFilenames, isStack = NULL, ...)

\method{updateFilenameSlots}{list}(obj, ...)

\method{updateFilenameSlots}{environment}(obj, ...)

makeMemoisable(x)

\method{makeMemoisable}{default}(x)

\method{makeMemoisable}{data.table}(x)

unmakeMemoisable(x)

\method{unmakeMemoisable}{default}(x)
}
\arguments{
\item{obj}{An object. This function only has useful methods for \verb{Raster*},
with all other classes being simply a pass-through}

\item{object}{Any R object returned from a function}

\item{functionName}{A character string indicating the function name}

\item{fromMemoise}{Logical. If \code{TRUE}, the message will be about
recovery from memoised copy}

\item{verbose}{Numeric, -1 silent (where possible), 0 being very quiet,
1 showing more messaging, 2 being more messaging, etc.
Default is 1. Above 3 will output much more information about the internals of
Caching, which may help diagnose Caching challenges. Can set globally with an
option, e.g., \verb{options('reproducible.verbose' = 0) to reduce to minimal}}

\item{fullCacheTableForObj}{The data.table entry from the Cache database for only
this \code{cacheId}, e.g., via \code{showCache()}.}

\item{cachePath}{A repository used for storing cached objects.
This is optional if \code{Cache} is used inside a SpaDES module.}

\item{cacheId}{Character string. If passed, this will override the calculated hash
of the inputs, and return the result from this \code{cacheId} in the \code{cachePath}.
Setting this is equivalent to manually saving the output of this function, i.e.,
the object will be on disk, and will be recovered in subsequent
This may help in some particularly finicky situations
where \code{Cache} is not correctly detecting unchanged inputs. This will guarantee
the object will be identical each time; this may be useful in operational code.}

\item{cacheSaveFormat}{Character string: currently either \code{qs} or \code{rds}. Defaults to
\code{getOption("reproducible.cacheSaveFormat")}. \code{qs} may be faster but appears to have
narrower range of conditions that work; \code{rds} is safer, and may be slower.}

\item{outputObjects}{Optional character vector indicating which objects to
return. This is only relevant for list, environment (or similar) objects}

\item{FUN}{A function}

\item{preDigestByClass}{A list, usually from \code{.preDigestByClass}}

\item{create}{Logical. If TRUE, then it will create the path for cache.}

\item{...}{Anything passed to methods.}

\item{preDigest}{The full, element by element hash of the input arguments to that same function,
e.g., from \code{.robustDigest}}

\item{origArguments}{These are the actual arguments (i.e., the values, not the names) that
were the source for \code{preDigest}}

\item{curFilenames}{An optional character vector of filenames currently existing
and that are pointed to in the obj. If omitted, will take from the \code{obj}
using \code{Filenames(obj)}}

\item{newFilenames}{An optional character vector of filenames to use instead of
the curFilenames. This can also be a single directory, in which case the
renaming will be given:
\code{file.path(newFilenames, basename(Filenames(obj, allowMultiple = FALSE)))}}

\item{x}{An object to make memoisable.
See individual methods in other packages.}
}
\value{
\code{.sortDotsUnderscoreFirst}: the same object as \code{obj},
but sorted with dots and underscores first,
lower case before upper case.

\code{.tagsByClass} default method returns \code{NULL}.

\code{.cacheMessage}: nothing; called for its messaging side effect, which,
by default, just edits the name of the function into a generic "loaded cached result"
message.

\code{.addTagsToOutput}: The inputted object but with tags attached.

\code{.preDigestByClass}: A list with elements that have a difficult time
being digested correctly, e.g., an S4 object with some elements removed and
handled for digesting purposes. The default method for \code{preDigestByClass} and
simply returns \code{NULL}.

\code{.checkCacheRepo}: A character string with a path to a cache repository.

\code{.prepareOutput}: The object, modified

\code{.addChangedAttr}: the object, with an attribute ".Cache" and sub-element, "changed",
added set to either \code{TRUE} or \code{FALSE}

\code{updateFilenameSlots}: The original object, but with its internal file pointer
updated to the \code{newFilenames}

The same object, but with any modifications, especially
dealing with saving of environments, which memoising doesn't handle
correctly in some cases.
}
\description{
There are a number of generics that are exported for other packages to use.
These are listed below. They are not intended for use by normal users; rather,
they are made available for package developers to build specific methods.
}
\details{
\code{.sortDotsUnderscoreFirst}: This exists so Windows, Linux, and Mac machines can have
the same order after a sort. It will put dots and underscores first
(with the sort key based on their second character, see examples.
It also sorts lower case before upper case.

The methods should do as described below.

\code{.tagsByClass} should return a character vector, with a single colon (":") dividing
two parts: the tag type and tag value, for the specific class.

\code{.cacheMessage} should make a call to \code{message} that gives information about
the loaded cached object being returned.

\code{.objecxtToRetrieveMessage} is the messaging for recovering an object from Cache.

\code{.addTagsToOutput} should add one or more attributes to an object, named either
\code{"tags"}, \code{"call"} or \code{"function"}. It may be wise to do a "deep" copy within this
method, but it may not be necessary.

\code{.addChangedAttr} should return the same object, with this a very specific
attribute added: it must be named ".Cache", and have a sub-list element named
"changed", which must be a logical, \code{TRUE} or \code{FALSE}, to describe whether the object
has changed or not since last attempt to cache it. This is mostly useful when there
are only one or a few sub-elements of e.g., a large list, that are changed. \code{Cache}
will be able to only recover the changed parts, to reduce time required to
complete a call to \code{Cache}.

\code{updateFilenameSlots}: this exists because when copying file-backed rasters, the
usual mechanism of \code{writeRaster} can be very slow. This function allows
for a user to optionally create a hard link to the old file, give it a new
name, then update the filename slot(s) in the \verb{Raster*} class object. This
can be 100s of times faster for large rasters.

\code{makeMemoiseable} and \code{unmakeMemoisable} methods are run during \code{Cache}. The
methods should address any parts that will not successfully work for memoising,
most notably, \code{data.table} or other pass-by-reference objects likely need to
be deep copied, so that the memoised version doesn't get changed after being
stashed in the RAM cache (i.e., memoised)

\code{makeMemoiseable} and \code{unmakeMemoisable} are, by default, just a pass through
for most class. \code{reproducible} only has a method for \code{data.table} class objects.
}
\examples{
items <- c(A = "a", Z = "z", `.D` = ".d", `_C` = "_C")
.sortDotsUnderscoreFirst(items)

# dots & underscore (using 2nd character), then all lower then all upper
items <- c(B = "Upper", b = "lower", A = "a", `.D` = ".d", `_C` = "_C")
.sortDotsUnderscoreFirst(items)

# with a vector
.sortDotsUnderscoreFirst(c(".C", "_B", "A")) # _B is first

.tagsByClass(character())

a <- 1
.cacheMessage(a, "mean")

a <- 1
.preDigestByClass(a) # returns NULL in the simple case here.

a <- normalizePath(file.path(tempdir(), "test"), mustWork = FALSE)
.checkCacheRepo(a, create = TRUE)

a <- 1
.prepareOutput(a) # does nothing

b <- "NULL"
.prepareOutput(b) # converts to NULL

if (requireNamespace("terra", quietly = TRUE)) {
  r <- terra::rast(terra::ext(0, 10, 0, 10), vals = 1:100)

  # write to disk manually -- will be in tempdir()
  r <- terra::writeRaster(r, filename = tempfile(fileext = ".tif"))

  # copy it to the cache repository
  r <- .prepareOutput(r, tempdir())
}
a <- 1
.addChangedAttr(a) # does nothing because default method is just a pass through
}
\author{
Eliot McIntire
}
\keyword{internal}
