% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_reptilebd_data.R
\name{get_reptiledb_data}
\alias{get_reptiledb_data}
\title{Access Reptile Database Taxonomic Information
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}}
\source{
Uetz, P., Freed, P., & Hosek, J. (eds.) (2021). The Reptile Database.
Available at: \url{https://reptile-database.reptarium.cz}

For more on phylogenetic background see:
Zheng, Y., & Wiens, J. J. (2016). Combining phylogenomics and fossils in higher-level squamate reptile phylogeny. \emph{BMC Evolutionary Biology}, 16, 1-20.
}
\usage{
get_reptiledb_data(species_names, timeout = 10, quiet = FALSE)
}
\arguments{
\item{species_names}{A character string with the scientific name of the species
(e.g., "Crocodylus acutus").}

\item{timeout}{Maximum waiting time for each request (in seconds)}

\item{quiet}{Logical value TRUE or FALSE.}
}
\value{
A list or data frame containing available taxonomic information
(e.g., accepted name, synonyms, family, distribution, literature references).
}
\description{
Retrieves taxonomic information on living reptile species from
\href{https://reptile-database.reptarium.cz/}{The Reptile Database}.
This function allows users to explore scientific names, synonyms,
distributions, and taxonomic references for all known species
of snakes, lizards, turtles, amphisbaenians, tuataras, and crocodiles.
}
\details{
The Reptile Database currently includes more than 10,000 species
and around 2,800 subspecies. It focuses on taxonomic and nomenclatural data,
including valid names, synonyms, type localities, distribution, and original
references. However, ecological and behavioral data are largely absent.

Data are compiled from peer-reviewed literature, expert contributions,
and curated by an editorial team. Updates and corrections from users
are welcome and help improve the resource.

The classification follows recent phylogenetic studies (e.g., Zheng & Wiens, 2016),
although the database takes a conservative approach to rapidly changing
taxonomic hypotheses. New genera or species proposals may first appear
in the "synonyms" field pending wider scientific acceptance.

Note: The database does not support species identification by traits,
but users can search by geographical distribution and higher taxonomic groups.
}
\examples{

get_reptiledb_data("Anolis carolinensis",
                           quiet = TRUE)

}
\seealso{
\url{https://reptile-database.reptarium.cz}
}
\author{
Data curated by P. Uetz and collaborators. Function implementation by Paul E. Santos Andrade.
}
