% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_reptiledbr.R
\name{reptiledbr_partial}
\alias{reptiledbr_partial}
\title{Fuzzy Search for Species Names Using Approximate Matching}
\usage{
reptiledbr_partial(species_names, max_dist = 2)
}
\arguments{
\item{species_names}{Character vector. One or more scientific names or fragments to match approximately.}

\item{max_dist}{Maximum string distance allowed for a match (default: 2).}
}
\value{
A tibble with matched species, taxonomic info, fuzzy match flag, and subspecies presence.
The response variable may return different messages depending on the outcome of the query.
Possible values include:
\itemize{
\item \code{"Species not found"} – The specified species could not be matched in the database.
\item \code{"Species has subspecies"} – The specified species exists and has one or more subspecies registered.
\item \code{"No subspecies found"} – The species was found, but there are no subspecies associated with it in the database.
}
}
\description{
This function performs approximate (fuzzy) matching of species names from a given list of input terms
against the species names in the reptile database, and indicates whether each matched species has subspecies.
}
\examples{
\dontrun{
# These examples require the 'reptiledb.data' package to be installed.
reptiledbr_partial(c("Ablepharus alaicuss", "Anolis limom"))
}
}
