% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{opls_gs}
\alias{opls_gs}
\title{orthogonal scores algorithm of partial leat squares (opls)}
\usage{
opls_gs(Xr, 
        Yr,
        Xu, 
        ncomp,
        scale,     
        response = FALSE, 
        reconstruction = TRUE,
        similarity = TRUE,
        fresponse = TRUE,
        algorithm = "pls")
}
\arguments{
\item{Xr}{a matrix of predictor variables for the training set.}

\item{Yr}{a matrix of a single response variable for the training set.}

\item{Xu}{a matrix of predictor variables for the test set.}

\item{ncomp}{the number of pls components.}

\item{scale}{logical indicating whether \code{X} must be scaled.}

\item{response}{logical indicating whether to compute the prediction of \code{Yu}.}

\item{reconstruction}{logical indicating whether to compute the reconstruction error of \code{Xu}.}

\item{similarity}{logical indicating whether to compute the the distance score between \code{Xr} and \code{Xu} (in the pls space).}

\item{fresponse}{logical indicating whether to compute the score of the variance not explained for \code{Yu}.}

\item{algorithm}{(for weights computation) a character string indicating
what method to use. Options are:
\code{'pls'} for pls (using covariance between X and Y) or
\code{'mpls'} for modified pls (using correlation between X and Y).}
}
\value{
a list containing the following elements:
\itemize{
\item{\code{ncomp}: the number of components.}
\item{\code{pred_response}: the response predictions for \code{Xu}.}
\item{\code{rmse_reconstruction}: the rmse of the reconstruction for \code{Xu}.}
\item{\code{score_dissimilarity}: the distance score between \code{Xr} and \code{Xu}.}}
}
\description{
Computes orthogonal scores partial least squares (opls)
regressions with the NIPALS algorithm. It allows multiple response variables.
It does not return the variance information of the components. NOTE: For
internal use only!
}
\author{
Leonardo Ramirez-Lopez
}
\keyword{internal}
