% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_auth.R
\name{gen_auth_save}
\alias{gen_auth_save}
\title{Save database credentials}
\usage{
gen_auth_save(database, use_token = FALSE)
}
\arguments{
\item{database}{Character string. The database to store credentials for ('all', 'genesis', 'zensus' or 'regio').}

\item{use_token}{Boolean. Do you want to (if possible) set an API token instead of password + username? Note: This is not supported by regionalstatistik.de. Defaults to FALSE.}
}
\value{
Path to the RDS file in which credentials are saved, invisibly.
}
\description{
Save credentials of the different databases for further convenient use
}
\details{
Username and password are encrypted and saved as RDS in the
package config directory. A random string is generated and stored in the
session environment variable \code{GENESIS_KEY}. This string is used as the key
to encrypt and decrypt the entered credentials. To avoid having to save
authentication in future sessions, \code{GENESIS_KEY} can be added to .Renviron.
The \code{{usethis}} package includes a helper function for editing .Renviron files
from an R session with \code{\link[usethis:edit]{usethis::edit_r_environ()}}.
}
\examples{
\dontrun{
gen_auth_save("zensus")
}

}
