/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.nvalue;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropAtLeastNValues
extends Propagator<IntVar> {
    private final int[] concernedValues;
    private final int n;
    private final int[] mate;

    public PropAtLeastNValues(IntVar[] variables, IntVar nValues) {
        super((Variable[])ArrayUtils.concat(variables, nValues), (Priority)PropagatorPriority.QUADRATIC, false);
        this.n = variables.length;
        this.concernedValues = this.model.getDomainUnion(variables);
        this.mate = new int[this.concernedValues.length];
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        ((IntVar[])this.vars)[this.n].updateUpperBound(this.n, (ICause)this);
        int count = 0;
        int countMax = 0;
        for (int i = this.concernedValues.length - 1; i >= 0; --i) {
            boolean possible = false;
            boolean mandatory = false;
            this.mate[i] = -1;
            int value = this.concernedValues[i];
            for (int v = 0; v < this.n; ++v) {
                if (!((IntVar[])this.vars)[v].contains(value)) continue;
                possible = true;
                if (((IntVar[])this.vars)[v].isInstantiated()) {
                    mandatory = true;
                    this.mate[i] = -2;
                    break;
                }
                this.mate[i] = this.mate[i] == -1 ? v : -2;
            }
            if (possible) {
                ++countMax;
            }
            if (!mandatory) continue;
            ++count;
        }
        ((IntVar[])this.vars)[this.n].updateUpperBound(countMax, (ICause)this);
        boolean again = false;
        if (count < countMax && countMax == ((IntVar[])this.vars)[this.n].getLB()) {
            for (int i = this.concernedValues.length - 1; i >= 0; --i) {
                if (this.mate[i] < 0 || !((IntVar[])this.vars)[this.mate[i]].instantiateTo(this.concernedValues[i], (ICause)this)) continue;
                again = true;
            }
            if (!again) {
                int i;
                int nbInst = 0;
                for (i = 0; i < this.n; ++i) {
                    if (!((IntVar[])this.vars)[i].isInstantiated()) continue;
                    ++nbInst;
                }
                if (this.n - nbInst == countMax - count) {
                    for (i = this.concernedValues.length - 1; i >= 0; --i) {
                        int v;
                        boolean mandatory = false;
                        int value = this.concernedValues[i];
                        for (v = 0; v < this.n; ++v) {
                            if (!((IntVar[])this.vars)[v].isInstantiatedTo(value)) continue;
                            mandatory = true;
                            break;
                        }
                        if (!mandatory) continue;
                        for (v = 0; v < this.n; ++v) {
                            if (((IntVar[])this.vars)[v].isInstantiated() || !((IntVar[])this.vars)[v].removeValue(value, (ICause)this)) continue;
                            again = true;
                        }
                    }
                }
            }
        }
        if (count >= ((IntVar[])this.vars)[this.n].getUB()) {
            this.setPassive();
        } else if (again) {
            this.propagate(0);
        }
    }

    @Override
    public ESat isEntailed() {
        int countMin = 0;
        int countMax = 0;
        for (int i = this.concernedValues.length - 1; i >= 0; --i) {
            boolean possible = false;
            boolean mandatory = false;
            for (int v = 0; v < this.n; ++v) {
                if (!((IntVar[])this.vars)[v].contains(this.concernedValues[i])) continue;
                possible = true;
                if (!((IntVar[])this.vars)[v].isInstantiated()) continue;
                mandatory = true;
                break;
            }
            if (possible) {
                ++countMax;
            }
            if (!mandatory) continue;
            ++countMin;
        }
        if (countMin >= ((IntVar[])this.vars)[this.n].getUB()) {
            return ESat.TRUE;
        }
        if (countMax < ((IntVar[])this.vars)[this.n].getLB()) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }
}

