% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restopt_problem.R
\name{get_original_habitat}
\alias{get_original_habitat}
\title{Retrieve the original (i.e. not aggregated) habitat data.}
\usage{
get_original_habitat(problem)
}
\arguments{
\item{problem}{\code{\link[=restopt_problem]{restopt_problem()}} Restoration problem object.}
}
\value{
\code{\link[terra:rast]{terra::rast()}} The original (i.e. not aggregated) habitat data.
}
\description{
Retrieve the original (i.e. not aggregated) habitat data.
}
\examples{
\dontrun{
#' # load data
habitat_data <- rast(
  system.file("extdata", "habitat_hi_res.tif", package = "restoptr")
)

# create problem
problem <- restopt_problem(
       existing_habitat = habitat_data,
       aggregation_factor = 4,
       habitat_threshold = 0.7
)

plot(get_original_habitat(problem))
}

}
