% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_max_iic_objective.R
\name{set_max_iic_objective}
\alias{set_max_iic_objective}
\title{Set an objective to maximize the integral index of connectivity}
\usage{
set_max_iic_objective(problem, distance_threshold = -1, unit = "m")
}
\arguments{
\item{problem}{\code{\link[=restopt_problem]{restopt_problem()}} Restoration problem object.}

\item{distance_threshold}{\code{numeric} greater than 0. Minimum distance (in
\code{unit}) between two patches to consider them connected in the computation of
the IIC. The default value -1 causes the function to use 1 aggregated cell as
the distance threshold.}

\item{unit}{\code{unit} object or a \code{character} that can be coerced to a distance
unit (see \code{unit} package), or "cells" for cell width of aggregated
habitat raster. Units of the \code{distance_threshold} parameter. If the input
habitat raster does not use a projected coordinate system, only "cells" is
available. Meters by default, expected if \code{distance_threshold} is set to its
default value (-1), which causes the function to use 1 cell by default.}
}
\value{
An updated restoration problem (\code{\link[=restopt_problem]{restopt_problem()}} object.
}
\description{
Specify that a restoration problem (\code{\link[=restopt_problem]{restopt_problem()}}) should
the integral index of connectivity (IIC).
}
\details{
The integral index of connectivity (IIC) is a graph-based inter-patch
connectivity index based on a binary connection model (Pascual-Hortal &
Saura, 2006). Its maximization in the context of restoration favours
restoring the structural connectivity between large patches. IIC is unitless
and comprised between 0 (no connectivity) and 1 (all the landscape is
habitat, thus fully connected). The \code{distance_threshold} parameter indicates
to the solver how to construct the habitat graph, i.e. what is the minimum
distance between two patches to consider them as connected. Note that, as
the computation occurs on aggregated cells, if \code{distance_threshold} is used
with a different unit than "cells", it will be rounded to the closest
corresponding number of cells.
}
\examples{
\dontrun{
# load data
habitat_data <- rast(
  system.file("extdata", "habitat_hi_res.tif", package = "restoptr")
)

locked_out_data <- rast(
 system.file("extdata", "locked_out.tif", package = "restoptr")
)

# create problem with locked out constraints
p <- restopt_problem(
    existing_habitat = habitat_data,
    aggregation_factor = 16,
    habitat_threshold = 0.7
  ) \%>\%
  set_max_iic_objective() \%>\%
  add_restorable_constraint(
    min_restore = 5,
    max_restore = 5,
  ) \%>\%
  add_locked_out_constraint(data = locked_out_data) \%>\%
  add_settings(time_limit = 1)

# print problem
print(p)

# solve problem
s <- solve(p)

# plot solution
plot(s)
}

}
\references{
Pascual-Hortal, L., & Saura, S. (2006).
Comparison and development of new graph-based landscape connectivity indices:
Towards the priorization of habitat patches and corridors for conservation.
Landscape Ecology, 21(7), 959‑967. https://doi.org/10.1007/s10980-006-0013-z
}
\seealso{
Other objectives: 
\code{\link{set_max_mesh_objective}()},
\code{\link{set_max_nb_pus_objective}()},
\code{\link{set_max_restore_objective}()},
\code{\link{set_min_nb_patches_objective}()},
\code{\link{set_min_nb_pus_objective}()},
\code{\link{set_min_restore_objective}()},
\code{\link{set_no_objective}()}
}
\concept{objectives}
