% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_max_mesh_objective.R
\name{set_max_mesh_objective}
\alias{set_max_mesh_objective}
\title{Set an objective to maximize effective mesh size}
\usage{
set_max_mesh_objective(problem)
}
\arguments{
\item{problem}{\code{\link[=restopt_problem]{restopt_problem()}} Restoration problem object.}
}
\value{
An updated restoration problem (\code{\link[=restopt_problem]{restopt_problem()}}) object.
}
\description{
Specify that a restoration problem (\code{\link[=restopt_problem]{restopt_problem()}}) should
maximize effective mesh size.
}
\details{
The effective mesh size (MESH) is a measure of landscape fragmentation
based on the probability that two randomly chosen points are located in the
same patch (Jaeger, 2000). Maximizing it in the context of restoration
favours fewer and larger patches.
}
\examples{
\dontrun{
# load data
habitat_data <- rast(
  system.file("extdata", "habitat_hi_res.tif", package = "restoptr")
)

locked_out_data <- rast(
 system.file("extdata", "locked_out.tif", package = "restoptr")
)

# plot data
plot(rast(list(habitat_data, locked_out_data)), nc = 2)

# create problem with locked out constraints
p <- restopt_problem(
    existing_habitat = habitat_data,
    aggregation_factor = 16,
    habitat_threshold = 0.7
  ) \%>\%
  set_max_mesh_objective() \%>\%
  add_restorable_constraint(
    min_restore = 5,
    max_restore = 5,
  ) \%>\%
  add_locked_out_constraint(data = locked_out_data) \%>\%
  add_settings(time_limit = 1)

# print problem
print(p)

# solve problem
s <- solve(p)

# plot solution
plot(s)
}

}
\references{
Jaeger, J. A. G. (2000). Landscape division, splitting index, and effective
mesh size: New measures of landscape fragmentation. Landscape Ecology, 15(2),
115‑130. https://doi.org/10.1023/A:1008129329289
}
\seealso{
Other objectives: 
\code{\link{set_max_iic_objective}()},
\code{\link{set_max_nb_pus_objective}()},
\code{\link{set_max_restore_objective}()},
\code{\link{set_min_nb_patches_objective}()},
\code{\link{set_min_nb_pus_objective}()},
\code{\link{set_min_restore_objective}()},
\code{\link{set_no_objective}()}
}
\concept{objectives}
