% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution.R
\name{species_by_ecosystem}
\alias{species_by_ecosystem}
\title{Species list by ecosystem}
\usage{
species_by_ecosystem(
  ecosystem,
  species_list = NULL,
  server = getOption("FISHBASE_API", "fishbase"),
  version = "latest",
  db = NULL,
  ...
)
}
\arguments{
\item{ecosystem}{(character) an ecosystem name}

\item{species_list}{A vector of scientific names (each element as "genus species"). If empty, a table for all fish will be returned.}

\item{server}{Either "fishbase" or "sealifebase".}

\item{version}{a version string for the database. See \code{\link[=available_releases]{available_releases()}} for details.}

\item{db}{database connection, now deprecated.}

\item{...}{additional arguments, currently ignored}
}
\value{
a table of species ecosystems data
}
\description{
Species list by ecosystem
}
\examples{
\dontshow{if (interactive() ) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
species_by_ecosystem(ecosystem = "Arctic", server = "sealifebase")
}
\dontshow{\}) # examplesIf}
}
