% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection_search.R
\name{collection_search}
\alias{collection_search}
\alias{collection_export}
\title{Search GRSciColl collections}
\usage{
collection_search(
  query = NULL,
  name = NULL,
  fuzzyName = NULL,
  preservationType = NULL,
  contentType = NULL,
  numberSpecimens = NULL,
  accessionStatus = NULL,
  personalCollection = NULL,
  sourceId = NULL,
  source = NULL,
  code = NULL,
  alternativeCode = NULL,
  contact = NULL,
  institutionKey = NULL,
  country = NULL,
  city = NULL,
  gbifRegion = NULL,
  machineTagNamespace = NULL,
  machineTagName = NULL,
  machineTagValue = NULL,
  identifier = NULL,
  identifierType = NULL,
  active = NULL,
  displayOnNHCPortal = NULL,
  masterSourceType = NULL,
  replacedBy = NULL,
  sortBy = NULL,
  sortOrder = NULL,
  offset = NULL,
  limit = NULL,
  format = NULL,
  curlopts = list(http_version = 2)
)

collection_export(
  query = NULL,
  name = NULL,
  fuzzyName = NULL,
  preservationType = NULL,
  contentType = NULL,
  numberSpecimens = NULL,
  accessionStatus = NULL,
  personalCollection = NULL,
  sourceId = NULL,
  source = NULL,
  code = NULL,
  alternativeCode = NULL,
  contact = NULL,
  institutionKey = NULL,
  country = NULL,
  city = NULL,
  gbifRegion = NULL,
  machineTagNamespace = NULL,
  machineTagName = NULL,
  machineTagValue = NULL,
  identifier = NULL,
  identifierType = NULL,
  active = NULL,
  displayOnNHCPortal = NULL,
  masterSourceType = NULL,
  replacedBy = NULL,
  sortBy = NULL,
  sortOrder = NULL,
  offset = NULL,
  limit = NULL,
  format = "TSV",
  curlopts = list()
)
}
\arguments{
\item{query}{Simple full text search parameter. The value for this parameter
can be a simple word or a phrase. Wildcards are not supported.}

\item{name}{Name of a GrSciColl institution or collection.}

\item{fuzzyName}{It searches by name fuzzily so the parameter doesn't have
to be the exact name.}

\item{preservationType}{Preservation type of a GrSciColl collection. Accepts
multiple values.}

\item{contentType}{Content type of a GrSciColl collection. See here for
accepted values :
https://techdocs.gbif.org/en/openapi/v1/registry#/Collections/listCollections}

\item{numberSpecimens}{Number of specimens. It supports ranges and a \code{*} can
be used as a wildcard.}

\item{accessionStatus}{Accession status of a GrSciColl collection. Accepted
values : INSTITUTIONAL, PROJECT}

\item{personalCollection}{Flag for personal GRSciColl collections.}

\item{sourceId}{sourceId of MasterSourceMetadata.}

\item{source}{Source attribute of MasterSourceMetadata. Accepted values :
DATASET, ORGANIZATION, IH_IRN}

\item{code}{Code of a GrSciColl institution or collection.}

\item{alternativeCode}{Alternative code of a GrSciColl institution or
collection.}

\item{contact}{Filters collections and institutions whose contacts contain
the person key specified.}

\item{institutionKey}{Keys of institutions to filter by.}

\item{country}{Filters by country given as a ISO 639-1 (2 letter) country
code.}

\item{city}{Filters by the city of the address. It searches in both the
physical and the mailing address.}

\item{gbifRegion}{Filters by a gbif region
Available values : AFRICA, ASIA, EUROPE, NORTH_AMERICA, OCEANIA,
LATIN_AMERICA, ANTARCTICA.}

\item{machineTagNamespace}{Filters for entities with a machine tag in the
specified namespace.}

\item{machineTagName}{Filters for entities with a machine tag with the
specified name (use in combination with the machineTagNamespace parameter).}

\item{machineTagValue}{Filters for entities with a machine tag with the
specified value (use in combination with the machineTagNamespace and
machineTagName parameters).}

\item{identifier}{An identifier of the type given by the identifierType
parameter, for example a DOI or UUID.}

\item{identifierType}{An identifier type for the identifier parameter.
Available values : URL, LSID, HANDLER, DOI, UUID, FTP, URI, UNKNOWN,
GBIF_PORTAL, GBIF_NODE, GBIF_PARTICIPANT, GRSCICOLL_ID, GRSCICOLL_URI,
IH_IRN, ROR, GRID, CITES, SYMBIOTA_UUID, WIKIDATA, NCBI_BIOCOLLECTION,
ISIL, CLB_DATASET_KEY.}

\item{active}{Active status of a GrSciColl institution or collection.}

\item{displayOnNHCPortal}{Flag to show this record in the NHC portal.}

\item{masterSourceType}{The master source type of a GRSciColl institution.
or collection. Available values : GRSCICOLL, GBIF_REGISTRY, IH.}

\item{replacedBy}{Key of the entity that replaced another entity.}

\item{sortBy}{Field to sort the results by. It only supports the fields
contained in the enum. Available values : NUMBER_SPECIMENS.}

\item{sortOrder}{Sort order to use with the sortBy parameter.
Available values : ASC, DESC.}

\item{offset}{Determines the offset for the search results.}

\item{limit}{Controls the number of results in the page. Default 20.}

\item{format}{(character) Format of the export. Default is "TSV".
Only used for \link{collection_export}.}

\item{curlopts}{curlopts options passed on to \link[crul:HttpClient]{crul::HttpClient}.}
}
\value{
a \code{list}
}
\description{
Search GRSciColl collections
}
\details{
Will return GRSciColl collections data. \link{collection_export} will
return all of the results in a single \code{tibble}, while \link{collection_search} will
return a sample of results.
}
\examples{
\dontrun{
  collection_search(query="insect",limit=2)
  collection_search(name="Insects;Entomology", limit=2)
  collection_search(numberSpecimens = "0,100", limit=1)
  collection_search(institutionKey = "6a6ac6c5-1b8a-48db-91a2-f8661274ff80"
  , limit = 1)
  collection_search(query = "insect", country = "US;GB", limit=1)
} 
}
\references{
https://scientific-collections.gbif.org/connected-systems#grscicoll-data-coming-from-other-sources
}
