context("dataset")

test_that("dataset works as expected", {
  vcr::use_cassette("dataset", {
    d <- dataset(limit=3)
    y <- dataset(country="US",limit=3)
    t <- dataset(type="CHECKLIST",limit=3)
    i <- dataset(identifierType = "URL",limit=3)
    f <- dataset(identifier = 168,limit=3)
    m <- dataset(machineTagNamespace = "metasync.gbif.org",limit=3)
    n <- dataset(machineTagName = "datasetTitle",limit=3)
    v <- dataset(machineTagValue = "Borkhart",limit=3)
    o <- dataset(modified = "2023-04-01", limit=3) 
    q <- dataset(q = "dog", limit=3) 
    e <- dataset(deleted=TRUE,limit=3)
  })
  
  expect_is(e, "list")
  expect_named(e,c("meta","data"))
  expect_is(e$data,"tbl_df")
  expect_is(e$meta,"data.frame")
  expect_named(e$meta,c("offset", "limit", "endOfRecords", "count"))
  expect_is(e$data$key,"character")
  expect_lte(nrow(e$data),3)
  expect_is(e$data$deleted,"character")
  
  expect_is(q, "list")
  expect_named(q,c("meta","data"))
  expect_is(q$data,"tbl_df")
  expect_is(q$meta,"data.frame")
  expect_named(q$meta,c("offset", "limit", "endOfRecords", "count"))
  expect_is(q$data$key,"character")
  expect_lte(nrow(q$data),3)
  
  expect_is(o, "list")
  expect_named(o,c("meta","data"))
  expect_is(o$data,"tbl_df")
  expect_is(o$meta,"data.frame")
  expect_named(o$meta,c("offset", "limit", "endOfRecords", "count"))
  expect_is(o$data$key,"character")
  expect_lte(nrow(o$data),3)
  
  expect_is(v, "list")
  expect_named(v,c("meta","data"))
  expect_is(v$data,"tbl_df")
  expect_is(v$meta,"data.frame")
  expect_named(v$meta,c("offset", "limit", "endOfRecords", "count"))
  expect_is(v$data$key,"character")
  expect_lte(nrow(v$data),3)
  
  expect_is(n, "list")
  expect_named(n,c("meta","data"))
  expect_is(n$data,"tbl_df")
  expect_is(n$meta,"data.frame")
  expect_named(n$meta,c("offset", "limit", "endOfRecords", "count"))
  expect_is(n$data$key,"character")
  expect_lte(nrow(n$data),3)
  
  expect_is(m, "list")
  expect_named(m,c("meta","data"))
  expect_is(m$data,"tbl_df")
  expect_is(m$meta,"data.frame")
  expect_named(m$meta,c("offset", "limit", "endOfRecords", "count"))
  expect_is(m$data$key,"character")
  expect_lte(nrow(m$data),3)
  
  expect_is(f, "list")
  expect_named(f,c("meta","data"))
  expect_is(f$data,"tbl_df")
  expect_is(f$meta,"data.frame")
  expect_named(f$meta,c("offset", "limit", "endOfRecords", "count"))
  expect_is(f$data$key,"character")
  expect_equal(nrow(f$data),1)
  
  expect_is(i, "list")
  expect_named(i,c("meta","data"))
  expect_is(i$data,"tbl_df")
  expect_is(i$meta,"data.frame")
  expect_named(i$meta,c("offset", "limit", "endOfRecords", "count"))
  expect_is(i$data$key,"character")
  expect_lte(nrow(i$data),3)
  
  expect_is(t, "list")
  expect_named(t,c("meta","data"))
  expect_is(t$data,"tbl_df")
  expect_is(t$meta,"data.frame")
  expect_named(t$meta,c("offset", "limit", "endOfRecords", "count"))
  expect_is(t$data$key,"character")
  expect_lte(nrow(t$data),3)
  
  expect_is(d, "list")
  expect_named(d,c("meta","data"))
  expect_is(d$data,"tbl_df")
  expect_is(d$meta,"data.frame")
  expect_named(d$meta,c("offset", "limit", "endOfRecords", "count"))
  expect_is(d$data$key,"character")
  expect_lte(nrow(d$data),3)
  
  expect_is(y, "list")
  expect_named(y,c("meta","data"))
  expect_is(y$data,"tbl_df")
  expect_is(y$meta,"data.frame")
  expect_named(y$meta,c("offset", "limit", "endOfRecords", "count"))
  expect_is(y$data$key,"character")
  expect_lte(nrow(y$data),3)
  
  })